@extends('layouts/main')
@section('page_title')Careers | Apply Now for Staff Nurse & Doctors Job in India at NU Hospitals
@endsection
@section('page_description')Get a chance to build your career with NU Hospitals, we provide tremendous opportunities to our students to explore, with extensive practical sessions. Visit here for current openings.
@endsection
@section('canonical')https://www.nuhospitals.com/ @endsection
@section('customcss')

@section('title')
{{trans('Best | Famous | Top Kidney Transplant Hospital Padmanabhanagar| Bangalore ')}}
@stop
@section('description', 'NU Trust is one of the Best Kidney Transplant Hospital Padmanabhanagar, Bangalore. Best Kidney Specialist for Chronic Kidney Disease & Acute Kidney Disease, Call Now.')
@section('keywords', 'Best Kidney Transplant Hospital Rajajinagar, Famous Kidney Transplant Hospital Padmanabhanagar, Top Kidney Transplant Hospital Padmanabhanagar')
<style type="text/css">
  .owl-item ul li {
    /* color: #626262; */
    font-size: 14px;
    text-align: left;
    font-weight: 300;
    letter-spacing: 1px;
    line-height: 1.5;
    text-transform: none;
  }

  .counter {
    text-align: center;
  }

  .employees,
  .customer,
  .design,
  .order {
    margin-top: 50px;
    margin-bottom: 50px;
  }

  .counter-count {
    font-size: 18px;
    background-color: #00b3e7;
    border-radius: 50%;
    position: relative;
    color: #ffffff;
    text-align: center;
    line-height: 92px;
    width: 92px;
    height: 92px;
    -webkit-border-radius: 50%;
    -moz-border-radius: 50%;
    -ms-border-radius: 50%;
    -o-border-radius: 50%;
    display: inline-block;
  }

  .employee-p,
  .customer-p,
  .order-p,
  .design-p {
    font-size: 24px;
    color: #000000;
    line-height: 34px;
    text-align: center;
  }

  .milestones {
    position: absolute;
    left: 0;
  }

  .milestones.img-height {
    height: 72%;
  }

  @media (min-width: 786px) {
    #get-started {
      margin-top: 0rem;
    }

    .carousel-inner img {
      height: 500px;
    }

    .owl-theme h4 {
      min-height: 10rem;
    }

    .team-block img {
      width: 70% !important;
    }

    #team .team-block {
      box-shadow: none !important;
    }
  }

  @media (min-width: 786px) {
    .addressbox p {
      padding: 0rem 2rem;
    }

    .addressbox h4 {
      padding: 0rem 2rem;
    }
  }

  .sidebar {
    margin: 0;
    padding: 10px;
    box-shadow: 0px 0px 30px rgb(127 137 161 / 25%);
    background: #fff;
    float: left;
  }

  .sidebar-menu {
    margin: 0;
    padding: 10px;
  }

  .sidebar-menu li {
    list-style: none;
    text-align: left;
    line-height: 1.6;
  }

  .sidebar-menu li a {
    padding: 10px;
    color: #333;
    transition: 0.3s;
    display: block;
    font-size: 14px;
    font-family: "Roboto", sans-serif;
    font-weight: 400;
    transition: 0.5s ease;
  }

  .sidebar-menu li a:hover {
    color: #ec3237;
  }

  .home-donation-content-wrapper {
    box-shadow: 0px 0px 30px rgb(127 137 161 / 25%);
    background: #fff;
    min-height: 200px;
    margin-bottom: 30px;
    float: left;
  }

  .home-donation-content-wrapper img {
    width: 100%;
    height: 175px;
    object-fit: cover;
  }

  .clear-filter {
    color: #ec3237;
    cursor: pointer;
    font-size: 12px;
    border-bottom: 1px dashed;
    display: none;
    float: right;
  }

  .alert-labels-wrapper {
    width: 100%;
    float: left;
    margin-bottom: 15px;
  }

  .alert-labels {
    color: #fff;
    font-size: 12px;
    padding: 5px 10px;
  }

  .green-label {
    float: left;
    background: #117f58;
  }

  .red-label {
    float: right;
    background: #dc2113;
  }

  .home-donation-content h4,
  .home-donation-content p {
    text-align: center;
  }

  .home-donation-content h4 {
    justify-content: center;
    display: flex;
    align-items: center;
  }

  .home-donation-content {
    padding: 10px 15px 30px;
    float: left;
  }

  .social-share-wrapper {
    text-align: center;
    margin-top: 15px;
  }

  .share-btn {
    border: 1px solid;
    padding: 3px 10px;
    margin-left: 10px;
    cursor: pointer;
    vertical-align: middle;
    display: inline-block;
    transition: 0.3s;
    font-size: 14px;
    color: #333;
    border-radius: 20px;
  }

  .share-btn.whatsapp:hover {
    background: #25D366;
    color: #fff;
  }

  .share-btn.facebook:hover {
    background: #1b74e4;
    color: #fff;
  }

  .error {
    color: #dc2113;
  }

  @media only screen and (max-width: 900px) {
    .strip span {
      float: none !important;
    }

    .strip {
      margin-top: 5px;
    }
  }
</style>
@endsection
@section('content')
<!--==========================
    Hero Section
  ============================-->
<section class="wow fadeIn" id="get-started">
  <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">

    <div class="carousel-inner" role="listbox">

      <div class="carousel-item  active">
        <img src="{{ url('img/banner/great-place-to-work-banner.jpeg') }}" class="w-100">
        <!-- <div class="top-top">

                    <h2>Our Users Speack volumes us</h2>
                    <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type
                      specimen book. It has survived not only five centuries.</p>
                    <h4>David Spark<span>Manager-Projects</span></h4>

                  </div> -->
      </div>
      <div class="carousel-item">
        <img src="{{ url('img/banner/B5.jpg') }}" class="w-100">
        <!-- <div class="top-top">

                    <h2>Our Users Speack volumes us</h2>
                    <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type
                      specimen book. It has survived not only five centuries.</p>
                    <h4>David Spark<span>Manager-Projects</span></h4>

                  </div> -->
      </div>
      <div class="carousel-item ">
        <img src="{{ url('img/banner/B6.jpg') }}" class="w-100">

      </div>
      <!-- <div class="carousel-item ">
                  <img src="{{ url('img/banner/Volunteer-banner.png') }}" class="w-100">

                </div> -->

      <div class="carousel-item ">
        <img src="{{ url('img/banner/B8.jpg') }}" class="w-100">

      </div>

      <div class="carousel-item ">
        <img src="{{ url('img/banner/B7.jpg') }}" class="w-100">

      </div>

    </div>

    <div class="btm-btm" style="text-align: center;margin-top: -2rem;">

      <ul class="list-unstyled carousel-indicators">
        <li data-target="#carousel-example-generic" data-slide-to="0" class="active"></li>
        <li data-target="#carousel-example-generic" data-slide-to="1"></li>
        <li data-target="#carousel-example-generic" data-slide-to="2"></li>
        <li data-target="#carousel-example-generic" data-slide-to="3"></li>
      </ul>

    </div>

  </div>
  <div class="strip"><span>"NU Trust is recognized under Section 80(5)(vi) of the Indian Income Tax Act, 1961, for tax exemption"</span></div>
</section><!-- #hero -->

<!--==========================
    Get Started Section
  ============================-->

<section class="section pt-5 padd-section wow fadeInUp">
  <div class="container">
    <div class="row">
      <div class="col-md-12 section-title text-center">
        <h2>Support Our Campaigns</h2>
      </div>
    </div>
    <div class="row">
      <div class="col-md-3 col-lg-3">
        <div class="sidebar">
          <ul class="sidebar-menu">
            <li> <a href="javascript:void(0)" onclick="RenderDonationLists('Paediatric Kidney Transplant');">Paediatric Kidney Transplant</a></li>
            <li><a href="javascript:void(0)" onclick="RenderDonationLists('Adult Kidney Transplant');">Adult Kidney Transplant</a></li>
            <li><a href="javascript:void(0)" onclick="RenderDonationLists('Paediatric Uro-Genital Abnormalities');">Paediatric Uro-Genital Abnormalities</a></li>
            <li><a href="javascript:void(0)">Uro-Oncology Treatment</a></li>
            <li><a href="javascript:void(0)" onclick="RenderDonationLists('Milaap');">Milaap</a></li>
            <li><a href="javascript:void(0)" onclick="RenderDonationLists('Impact Guru');">Impact Guru</a></li>
            <!-- <li><a href="javascript:void(0)" onclick="RenderDonationLists('Liver Transplant');">Donation for OBW - Mr Sukha Ravinder (Treatment Expenses)</a></li> -->
          </ul>
          <p class="text-right clear-filter" onclick="RenderDonationLists();">Clear Filter X</p>
        </div>
      </div>
      <div class="col-md-9 col-lg-9">
        <div class="row" id="donations-lists">

        </div>
      </div>
    </div>
  </div>
</section>


<section id="contact" class="padd-section wow fadeInUp">

  <div class="container">

    <div class="section-title text-center">
      <h2>About NU Trust</h2>
    </div>
  </div>
  <div class="container">
    <div class="row addressbox">
      <div class="col-md-6">
        <h3>Our Charitable Wing – Reaching out with Compassion</h3>
        <p>The hospital caters to the poor and needy through the charitable wing. NU Trust is actively involved in several community outreach activities on an ongoing basis such as organizing of free health camps, convening of seminars on the prevention of nephrology-urology disorders and giving back to the society by providing the best of its knowledge and service resources.</p>
        <h3>Affordable Care</h3>
        <p>To the thousands of less privileged patients diagnosed with renal disease, long-term care involves enormous expense, especially for haemodialysis as well as transplant, and its post-operative care. With assistance from the government, and private sponsors, needy patients are provided treatment either at subsidized cost or even totally free, with funds collected from donors. The main criterion to be eligible for subsidized care at NU Trust is economic need, determined both by the doctors as well as the medico-social workers at the hospital.</p>
        <!-- <a class="red-btn" href="about-nu-trust">Read more <i class="fa fa-arrow-right"></i></a> -->
      </div>
      <div class="col-md-6 px-5">
        <div class="row px-3 py-3" style="box-shadow: 0 0 25px rgba(0, 0, 0, 0.1);">
          <h3>OUR SUCCESS STORY</h3>
          <img src="{{ url('img/Image_1.jpg') }}" alt="img" class="w-100">
          <p>A 12 year old boy was leaking urine continuously from birth. This was because of him having a rare congenital condition (Epispadias) where the front part of his urethra (The tube that connects the bladder to the tip of the penis) was missing.</p>
          <a class="red-btn" href="our-success-stories">Read more <i class="fa fa-arrow-right"></i></a>
        </div>
      </div>
    </div>


  </div>
</section>
<section id="testimonials" class="padd-section text-center wow fadeInUp">
  <img src="{{ url('img/banner/Image_2.jpg') }}" class="w-100 milestones img-height">
  <div class="counter">
    <div class="container text-center py-5 tb-color">
      <h2 class="py-3" style="color: #fff;position: relative;">Milestones</h2>
      <p class="text-center px-10" style="color: #fff;position: relative;font-weight: 500;    font-size: 1rem;">We have served thousands of patients in a relatively short amount of time.<br> We will continue expanding our care in order to serve as many patients as we can.</p>
      <div class="row">
        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
          <div class="employees">
            <img src="{{ url('img/Patients-treated-icon.png') }}">
            <p class="employee-p pt-3" style="font-size: 2rem;color: #fff;position: relative;font-weight: 500;">13162</p>
            <p class="employee-p pt-3" style="color: #fff;position: relative;font-weight: 500;">Patients availed subsidy from NU Trust </p>

          </div>
        </div>

        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
          <div class="customer">
            <img src="{{ url('img/Employees-icon.png') }}">
            <p class="customer-p pt-3" style="font-size: 2rem;color: #fff;position: relative;font-weight: 500;"> 209</p>
            <p class="customer-p pt-3" style="color: #fff;position: relative;font-weight: 500;"> Employees children educated through NU Trust </p>

          </div>
        </div>


      </div>
    </div>
  </div>

</section>
<section class="padd-section wow fadeInUp">

  <div class="container">
    <div class="section-title text-center">
      <h2>Get involved</h2>
    </div>
    <div class="row addressbox">
      <div class="col-md-4" style="background-color: #ff7578">
        <div class="row px-5 py-5">
          <h3 style="color: #fff;">Donate/Fundraise</h3>
          <p style="color: #fff;">Your donation can help us deliver health & hope to the needy people around the globe.
          </p>
          <span><a href="get-involved">Read more <i class="fa fa-arrow-right"></i>
            </a></span>
        </div>
      </div>
      <div class="col-md-4" style="background-color: #f1595d">
        <div class="row px-5 py-5">
          <h3 style="color: #fff;">CSR Opportunities</h3>
          <p style="color: #fff;">For CSR partnerships and institutional enquiries, please write to us below.<br>&nbsp;</p>
          <span><a href="get-involved">Read more <i class="fa fa-arrow-right"></i>
            </a></span>
        </div>
      </div>
      <div class="col-md-4" style="background-color: #d4363a">
        <div class="row px-5 py-5">
          <h3 style="color: #fff;">Volunteers</h3>
          <p style="color: #fff;">NU Trust warmly invites people who can volunteer with us.<br>&nbsp;</p>
          <span><a href="get-involved">Read more <i class="fa fa-arrow-right"></i>
            </a></span>
        </div>
      </div>
    </div>
  </div>
</section>



<!--==========================
    Team Section
  ============================-->
<section id="team" class="padd-section text-center wow fadeInUp">

  <div class="container">
    <div class="about-content">
      <div id="volunteers" class="section-title text-center mb-1">
        <h2><span>Our </span>Volunteers</h2>
      </div>
      <p class="text-center mb-4">Your time and skills are valuable to us and can be lifesavers to someone. When you work with NU Trust, you can provide care to patients with our wide range of projects and initiatives. Find opportunities to volunteer at NU Hospitals.
      </p>

    </div>
    <div class="row justify-content-center">

      <div class="col-sm-6 col-md-3 col-lg-3">
        <div class="team-block bottom">
          <img src="{{ url('img/voluntee/Our_Supporters_2.jpg') }}" class="img-responsive" alt="img">
          <div class="team-content">
            <!-- <ul class="list-unstyled">
                <li><a href="#"><i class="fa fa-facebook"></i></a></li>
                <li><a href="#"><i class="fa fa-twitter"></i></a></li>
                <li><a href="#"><i class="fa fa-linkedin"></i></a></li>
              </ul> -->
            <span>Unit Head</span>
            <h4>Sahana Paul</h4>
          </div>
        </div>
      </div>

      <div class="col-sm-6 col-md-3 col-lg-3">
        <div class="team-block bottom">
          <img src="{{ url('img/voluntee/Narayanmurthy_E.jpg') }}" class="img-responsive" alt="img">
          <div class="team-content">
            <!-- <ul class="list-unstyled">
                <li><a href="#"><i class="fa fa-facebook"></i></a></li>
                <li><a href="#"><i class="fa fa-twitter"></i></a></li>
                <li><a href="#"><i class="fa fa-linkedin"></i></a></li>
              </ul> -->
            <span>Chief Projects Officer</span>
            <h4>Narayana Murthy</h4>
          </div>
        </div>
      </div>

      <div class="col-sm-6 col-md-3 col-lg-3">
        <div class="team-block bottom">
          <img src="{{ url('img/voluntee/Our_Supporters_1.jpg') }}" class="img-responsive" alt="img">
          <div class="team-content">
            <!-- <ul class="list-unstyled">
                <li><a href="#"><i class="fa fa-facebook"></i></a></li>
                <li><a href="#"><i class="fa fa-twitter"></i></a></li>
                <li><a href="#"><i class="fa fa-linkedin"></i></a></li>
              </ul> -->
            <span>Chief People officer</span>
            <h4>Sahana Pai</h4>
          </div>
        </div>
      </div>
      <?php /*01-01-2024  <div class="col-sm-6 col-md-3 col-lg-3">
        <div class="team-block bottom">
          <img src="{{ url('img/voluntee/Charles Williams.jpg') }}" class="img-responsive" alt="img">
          <div class="team-content">
            <!-- <ul class="list-unstyled">
                <li><a href="#"><i class="fa fa-facebook"></i></a></li>
                <li><a href="#"><i class="fa fa-twitter"></i></a></li>
                <li><a href="#"><i class="fa fa-linkedin"></i></a></li>
              </ul> -->
            <span>Assistant Manager- Digital Initiatives</span>
            <h4>Charles Williams</h4>
          </div>
        </div>
      </div> */ ?>
    </div>
    <div class="row justify-content-center" style="display: none;">
      <div class="col-lg-8">
        <div class="contact-form">


          <form id="" name="contact-form4" class="default-form contactForm4" action="javascript:void(0);" method='post'>
            @csrf
            <input type="hidden" id="source_book" name="source" value="Web-NUH -Contact Us" />

            <h2>Book an Appointment</h2>
            <input type="hidden" name="title" value="NU Trust Home Page Become Our Volunteer Form" id="book_title">
            <div class="row">
              <div class="col-md-6">
                <input type="text" id="name4" name="name" value="" placeholder="Your Name*" required="" aria-required="true">
              </div>
              <div class="col-md-6">
                <input type="email" id="email4" name="email" value="" placeholder="Your Mail" aria-required="true">
                <span id="error_email4" class="error"></span>
              </div>
            </div>
            <div class="row">
              <div class="col-md-6 phonesection">
                <input type="tel" id="phone4" name="phone" class="phone_number TxtPhone" value="" placeholder="Phone*" required="" maxlength="15" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                <span id="error_phone4" class="error"></span>
              </div>
            </div>
            <div class="row">
              <div class="col-md-12">
                <textarea id="message4" name="message" placeholder="Your Message.." aria-required="true"></textarea>
              </div>
            </div>
            <div class="row">
              <div class="col-md-12">
                <input type="checkbox" id="field_terms" name="terms" checked required=""><small> &nbsp; I authorise NU Hospitals and its representative to contact me with updates and notifications via Email, SMS, WhatsApp, and Call. This will override the registry on DND / NDNC.</small>
              </div>
            </div>
            <div class="row">
              <div class="col-md-12">
                <input id="form_botcheck" name="form_botcheck" class="form-control" type="hidden" value="">
                <button class="thm-btn bgclr-1 g-recaptcha finalsubmit" type="submit" data-loading-text="Please wait..." data-sitekey="{{ env('GOOGLE_RECAPTCHA_KEY') }}" data-callback='onSubmitContact' data-action='submit'>Send Message</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
    <div class="text-center mt-1">
      <a data-toggle="modal" data-target="#myModalvolunteer" class="btn btn-primary btn-rounded mt-4">Become Our Volunteer</a>
    </div>
  </div>
  <!-- Modal -->
  <div class="modal fade" id="myModalvolunteer" role="dialog">
    <div class="modal-dialog">

      <!-- Modal content-->
      <!-- <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>

        </div>
        <br>
        <h4 class="modal-title text-center">Fill in your details</h4>
        <div class="modal-body">
          <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" id="contact">
            <div class="form">
              <div id="sendmessage">Your message has been sent. Thank you!</div>
              <div id="errormessage"></div>
              <form action="javascript:void(0);" id="book_appointment" method="post" role="form" class="contactForm">
                <div class="form-group">
                <input type="hidden" name="title" value="NU Trust Home Page Become Our Volunteer Form" id="title">
                  <input type="text" name="name" class="form-control" id="name" placeholder="Your Name" data-rule="minlen:4" data-msg="Please enter at least 4 chars">
                  <div class="validation"></div>
                </div>
                <div class="form-group">
                  <input type="email" class="form-control" name="email" id="email" placeholder="Your Email" data-rule="email" data-msg="Please enter a valid email">
                  <div class="validation"></div>
                </div>
                <div class="form-group">
                  <input type="tel" class="form-control" name="phone" id="phone" placeholder="Mobile" onkeypress="return event.charCode >= 48 && event.charCode <= 57" data-rule="minlen:10" data-msg="Please enter your mobile number">
                  <div class="validation"></div>
                </div>
                <div class="form-group">
                  <textarea class="form-control" id="message" name="message" rows="5" data-rule="required" data-msg="Please write something for us" placeholder="Message"></textarea>
                  <div class="validation"></div>
                </div>
                <div class="text-center"><button type="submit" data-loading-text="Please wait..." data-sitekey="{{ env('GOOGLE_RECAPTCHA_KEY') }}" onClick='onSubmitContact(this)' data-action='submit'>Send Message</button></div>
              </form>
            </div>
          </div>
        </div>

      </div> -->

      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>

        </div>
        <br>
        <h4 class="modal-title text-center">Fill in your details</h4>
        <div class="modal-body">
          <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" id="contact">
            <div class="form">
              <div id="sendmessage">Your message has been sent. Thank you!</div>
              <div id="errormessage"></div>
              <form action="javascript:void(0);" id="book_appointment" method="post" role="form" class="contactForm">
                <div class="form-group">
                  <input type="hidden" name="title" value="NU Trust Home Page Become Our Volunteer Form" id="title">
                  <input type="text" name="name" class="form-control" id="name" placeholder="Your Name">
                </div>
                <div class="form-group">
                  <input type="email" class="form-control" name="email" id="email" placeholder="Your Email">
                </div>
                <div class="form-group">
                  <input type="tel" class="form-control" name="phone" id="phone" placeholder="Mobile" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                  <span id="error_phone4" class="error"></span>
                </div>
                <div class="form-group">
                  <textarea class="form-control" id="message" name="message" rows="5" placeholder="Message"></textarea>
                </div>
                <!-- <div class="text-center"><button class="thm-btn bgclr-1 g-recaptcha" type="submit" data-loading-text="Please wait..." data-sitekey="{{env('GOOGLE_RECAPTCHA_KEY') }}" data-callback='onSubmitContact' data-action='submit'>Send Message</button></div> -->

                <div class="text-center"><button type="submit" data-loading-text="Please wait..." data-action='submit'>Send Message</button></div>
              </form>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>



@endsection
@section('customjs')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.20.0/jquery.validate.min.js" integrity="sha512-WMEKGZ7L5LWgaPeJtw9MBM4i5w5OSBlSjTjCtSnvFJGSVD26gE5+Td12qN5pvWXhuWaWcVwF++F7aqu9cvqP0A==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.2/jquery-ui.min.js" integrity="sha512-57oZ/vW8ANMjR/KQ6Be9v/+/h6bq9/l3f0Oc7vn6qMqyhvPd1cvKBRWWpzu0QoneImqr2SkmO4MSqU+RpHom3Q==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script>
  var donations_data = [
    // {
    //   title: "Liver Transplant",
    //   img_src: "Mr-Sukha-Ravinder-Liver-Transplant.jpg",
    //   short_content: "Sukha Ravinder, a facilities manager at One Bangalore West apartments, has late stage chronic liver disease and needs an early liver transplant. To donate please click below:",
    //   donate_link: "donations/liver-transplant?donation_towards=Liver Transplant",
    //   open_new_window: false,
    //   category: "Liver Transplant"
    // },
    // {
    //   title: "Help little Abu afford his four kidney stone removal surgeries!",
    //   img_src: "Impactguru-help-abhu.jpg",
    //   short_content: "Until January, 2020 our son Abu Bakar would keep saying how he wishes to make new friends, learn to read and write. Our 2-year-old boy was really excited to join nursery.",
    //   donate_link: "https://www.impactguru.com/fundraiser/help-abu-bakar-mk-story-v1-as",
    //   open_new_window: true,
    //   category: "Impact Guru"
    // },
    // {
    //   title: "Help My Daughter Recover Kidney Transplantation",
    //   img_src: "support-abhinaya-p.jpg",
    //   short_content: "My name is Parasuram and I am here to raise funds for my daughter Abhinaya. P who is 17 years old. Abhinaya. P lives in Bengaluru, Karnataka with her parents. Abhinaya. P is studying at 1st Puc.",
    //   donate_link: "https://milaap.org/fundraisers/support-abhinaya-p",
    //   open_new_window: true,
    //   category: "Milaap"
    // },
    {
      title: "Paediatric Kidney Transplant",
      img_src: "Pediatric kidney-Transplant.png",
      short_content: "A child weighing more than 10 kg can get an adult kidney, as long as the kidney fits in their body.",
      donate_link: "donations/paediatric-kidney-transplant",
      open_new_window: false,
      category: "Paediatric Kidney Transplant"
    },
    {
      title: "Adult Kidney Transplant",
      img_src: "Adult-Kidney-Transplant-1.png",
      short_content: "Renal transplant is carried out for patients with end-stage renal failure that is when the kidney function is irreversibly reduced to below 15% of normal.",
      donate_link: "donations/adult-kidney-transplant",
      open_new_window: false,
      category: "Adult Kidney Transplant"
    },
    {
      title: "Paediatric Uro-genital abnormalities",
      img_src: "uro-gental.png",
      short_content: "Paediatric urogenital disorders can affect the urinary tract or reproductive organs in children. If not corrected on time, these conditions may lead to significant mental, social and disability issues.",
      donate_link: "donations/paediatric-uro-genital-abnormalities",
      open_new_window: false,
      category: "Paediatric Uro-Genital Abnormalities"
    },
    {
      title: "Education for Children",
      img_src: "Education-for-children-1.png",
      short_content: "A good quality education helps children reach their full potential however, for millions of children and youth, it is beyond reach.",
      donate_link: "donations/education-for-children",
      open_new_window: false,
      category: ""
    }
  ];


  function shorten(text, max) {
    return text && text.length > max ? text.slice(0, max).split(' ').slice(0, -1).join(' ') : text
  }

  function RenderDonationLists(filter_val = "") {
    var donation_block_html = "";
    $("#donations-lists").html("");
    var donations_list = [];
    if (filter_val !== "") {
      donations_list = donations_data.filter(function(el) {
        return (el.category == filter_val);
      });
      $(".clear-filter").show();
    } else {
      donations_list = donations_data;
      $(".clear-filter").hide();
    }
    $.each(donations_list, function(index, value) {

      var donation_block = '<div class="col-md-4">' +
        '                        <div class="col-md-12 home-donation-content-wrapper">' +
        '                            <img src="ImgLink" alt=""' +
        '                                width="100%">' +
        '<div class="alert-labels-wrapper"><span class="alert-labels red-label">Urgent</span><span class="alert-labels green-label">Tax Benefits</span></div>                            <div class="col-md-12 home-donation-content">' +
        '                                <h4>Title</h4>' +
        '                                <p>ShortContent</p>' +
        '<div class="social-share-wrapper"><a href="whatsapp://send?text=ShareLink>" data-action="share/whatsapp/share" target="_blank" title="Share on whatsapp"><span class="share-btn whatsapp"><i class="fa fa-whatsapp"></i> Share</span></a><a href="http://www.facebook.com/sharer/sharer.php?u=ShareLink" target="_blank"><span class="share-btn facebook"><i class="fa fa-facebook-f"></i> Share</span></a></div>' +
        '                                <div class="text-center">' +
        '                                    <a LinkTarget href="DonationLink"' +
        '                                        class="btn btn-primary btn-rounded mt-4">Donate Now</a>' +
        '                                </div>' +
        '                            </div>' +
        '                        </div>' +
        '                    </div>';
      var short_heading = shorten(value.title, 40);
      var short_content = shorten(value.short_content, 98);
      if (value.short_content.length >= 100) {
        short_content = short_content + "..."
      }
      if (value.title.length >= 40) {
        short_heading = short_heading + "..."
      }
      var link_target = "";

      if (value.open_new_window === true) {
        link_target = 'target="_blank"';
      }

      donation_block_html += donation_block.replace(/Title/, short_heading)
        .replace(/ImgLink/, "/img/donation-images/" + value.img_src)
        .replace(/ShortContent/, short_content)
        .replace(/DonationLink/, value.donate_link)
        .replace(/LinkTarget/, link_target)
        .replace(/ShareLink/g, "https://nutrust.org/" + value.donate_link);

    });
    $("#donations-lists").html(donation_block_html);
  }

  RenderDonationLists();
</script>
<script type="text/javascript">
  $('.counter-count').each(function() {
    $(this).prop('Counter', 0).animate({
      Counter: $(this).text()
    }, {
      duration: 5000,
      easing: 'swing',
      step: function(now) {
        $(this).text(Math.ceil(now));
      }
    });
  });
  $('.owl-carousel').owlCarousel({
    loop: true,
    margin: 30,
    nav: true,
    responsive: {
      0: {
        items: 1
      },
      600: {
        items: 3
      },
      1000: {
        items: 4
      }
    }
  });
  // $(document).on('keyup', '#phone', function() {

  //   var a = $("#phone").val();
  //   var filter = /^[0-9-+]+$/;
  //   if (filter.test(a)) {
  //     if (a.length < 5) {

  //       $("#error_phone4").text('Number should be more than 4 and less than 15');
  //       return false;
  //     } else if (a.length > 16) {

  //       $("#error_phone4").text('Number should be more than 4 and less than 15');
  //       return false;
  //     } else {
  //       $('#error_phone4').text('');
  //       return true;
  //     }
  //   } else {
  //     $('#error_phone4').text('Phone number is not valid');
  //     return false;
  //   }
  // });
  $('#book_appointment').validate({
    rules: {
      name: {
        required: true,
      },
      phone: {
        required: true,
        minlength: 10,
        number: true,
      },
      email: {
        required: true,
      }
    },
    messages: {
      name: "Please enter your name",
      phone: {
        required: "Please enter your phone number",
        minlength: "Atleast enter 10 digit number required",
        number: "Only number should be allowed",
      },
      email:"Please enter your email"
    },
    submitHandler: function() {
      // var a = $('#error_phone4').text();
      // if (a) {
      //   return false;
      // }
      const name = $("#name").val();
      const email = $("#email").val();
      const contact = $("#phone").val();
      const title = $('#title').val();
      const message = $("#message").val();
      $('#name4').val(name);
      $('#email4').val(email);
      $('#phone4').val(contact);
      $('#message4').val(message);
      $('.finalsubmit').trigger('click');
    }
  });

  function onSubmitContact() {
    const name = $("#name4").val();
    const email = $("#email4").val();
    const contact = $("#phone4").val();
    const title = $('#book_title').val();
    const message = $("#message4").val();
    const data = {
      name: name,
      email: email,
      phone: contact,
      message: message,
      title: title,
      'g-recaptcha-response': grecaptcha.getResponse(),
      "_token": "{{ csrf_token() }}"
    };

    if ($(".contactForm4")[0].checkValidity()) {
        $.ajax({
            type: 'POST',
            url: "{{route('submitfunc')}}",
            data: data,
            success: function(data) {

                if(data.success){
                    console.log(data);
                    Swal.fire({
                        title: "Thank You!",
                        text: data.message,
                        icon: "success"
                    });
                }
                else{
                    Swal.fire({
                        title: "Oops...!",
                        text: data.message,
                        icon: "error"
                    });
                }
                $('#book_appointment')[0].reset();
                $('#myModalvolunteer').modal('hide');

            },
            error: function(err) {
                console.log(err);
            }

        });
        // $(".contactForm")[0].submit();

    } else {
        $(".contactForm4")[0].reportValidity();
    }
  }
</script>
@endsection