jQuery(document).ready(function( $ ) {

  $(window).scroll(function () {
    var height = $(window).height();
    var scroll = $(window).scrollTop();
    if (scroll) {
      $(".header-hide").addClass("scroll-header");
    } else {
      $(".header-hide").removeClass("scroll-header");
    }

  });

  // Back to top button
  $(window).scroll(function() {
    if ($(this).scrollTop() > 100) {
      $('.back-to-top').fadeIn('slow');
    } else {
      $('.back-to-top').fadeOut('slow');
    }
  });
  $('.back-to-top').click(function(){
    $('html, body').animate({scrollTop : 0},1500, 'easeInOutExpo');
    return false;
  });

  // Initiate the wowjs animation library
  new WOW().init();

  // Initiate superfish on nav menu
  $('.nav-menu').superfish({
    animation: {
      opacity: 'show'
    },
    speed: 400
  });

  // Mobile Navigation
  if ($('#nav-menu-container').length) {
    var $mobile_nav = $('#nav-menu-container').clone().prop({
      id: 'mobile-nav'
    });
    $mobile_nav.find('> ul').attr({
      'class': '',
      'id': ''
    });
    $('body').append($mobile_nav);
    $('body').prepend('<button type="button" id="mobile-nav-toggle"><i class="fa fa-bars"></i></button>');
    $('body').append('<div id="mobile-body-overly"></div>');
    $('#mobile-nav').find('.menu-has-children').prepend('<i class="fa fa-chevron-down"></i>');

    $(document).on('click', '.menu-has-children i', function(e) {
      $(this).next().toggleClass('menu-item-active');
      $(this).nextAll('ul').eq(0).slideToggle();
      $(this).toggleClass("fa-chevron-up fa-chevron-down");
    });

    $(document).on('click', '#mobile-nav-toggle', function(e) {
      $('body').toggleClass('mobile-nav-active');
      $('#mobile-nav-toggle i').toggleClass('fa-times fa-bars');
      $('#mobile-body-overly').toggle();
    });

    $(document).click(function(e) {
      var container = $("#mobile-nav, #mobile-nav-toggle");
      if (!container.is(e.target) && container.has(e.target).length === 0) {
        if ($('body').hasClass('mobile-nav-active')) {
          $('body').removeClass('mobile-nav-active');
          $('#mobile-nav-toggle i').toggleClass('fa-times fa-bars');
          $('#mobile-body-overly').fadeOut();
        }
      }
    });
  } else if ($("#mobile-nav, #mobile-nav-toggle").length) {
    $("#mobile-nav, #mobile-nav-toggle").hide();
  }

  // Smooth scroll for the menu and links with .scrollto classes
  $('.nav-menu a, #mobile-nav a, .scrollto').on('click', function() {
    if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
      var target = $(this.hash);
      if (target.length) {
        var top_space = 0;

        if ($('#header').length) {
          top_space = $('#header').outerHeight();

          if( ! $('#header').hasClass('header-fixed') ) {
            top_space = top_space - 20;
          }
        }

        $('html, body').animate({
          scrollTop: target.offset().top - top_space
        }, 1500, 'easeInOutExpo');

        if ($(this).parents('.nav-menu').length) {
          $('.nav-menu .menu-active').removeClass('menu-active');
          $(this).closest('li').addClass('menu-active');
        }

        if ($('body').hasClass('mobile-nav-active')) {
          $('body').removeClass('mobile-nav-active');
          $('#mobile-nav-toggle i').toggleClass('fa-times fa-bars');
          $('#mobile-body-overly').fadeOut();
        }
        return false;
      }
    }
  });

  // Modal video
  new ModalVideo('.js-modal-btn', {channel: 'youtube'});

  // Init Owl Carousel
  $('.owl-carousel').owlCarousel({
    items: 4,
    autoplay: true,
    loop: true,
    margin: 30,
    dots: true,
    responsiveClass: true,
    responsive: {

      320: { items: 1},
      480: { items: 2},
      600: { items: 2},
      767: { items: 3},
      768: { items: 3},
      992: { items: 4}
    }
  });

// custom code

});
var elementPosition = $('#header').offset();

$(window).scroll(function(){
        if($(window).scrollTop() > elementPosition.top){
              $('#header').css('position','fixed').css('top','0');
        } else {
            $('#header').css('position','relative');
        }    
});

// Donation Page Form Starts
$(document).ready(function(){

  $('.step-2').hide();
  $('.step-3').hide();


  $('.btn-donate-one').click(function(e){
    e.preventDefault();

    firstnamevalid = checkfirstname();
    lastnamevalid = checklastname();
    emailvalid = checkemail();
    phonenumbervalid = checkphonenumber();


    if (firstnamevalid == true && lastnamevalid ==true && emailvalid ==true && phonenumbervalid == true) {
      $('.step-1').hide();
      $('.step-3').hide();
      $('.step-2').show();
      $('.donation-menu').removeClass('donate-border-grey');
      $('.donation-menu').addClass('donate-border-red');
    }


  });


  $('.btn-donate-two').click(function(e){
    e.preventDefault();

    donationamountvalid = checkdonationamount();
    pancardnumbervalid = checkpancardnumber();
    certificatenamevalid = checkcertificatename();
    recepientnamevalid = checkrecepientname();

    if (donationamountvalid == true && pancardnumbervalid == true && certificatenamevalid == true && recepientnamevalid == true) {
      
      $.ajax({
        url: "/donation-form-submit",
        method: "POST",
        data: $('#donation-form').serialize(),
        success: function (data) {
          $('.step-1').hide();
          $('.step-2').hide();
          $('.step-3').show();
          console.log(data);
        }
      });
      
    } else {

    }

  });


  function checkfirstname(){
    if($('#first_name').val() == ''){
      $('#first_name').css({'border-bottom':'2px solid red'});
      return false;
    }else{
      $('#first_name').css({ 'border-bottom': '2px solid #777' });
      return true;
    }
  }

  function checklastname() {
    if ($('#last_name').val() == '') {
      $('#last_name').css({ 'border-bottom': '2px solid red' });
      return false;
    } else {
      $('#last_name').css({ 'border-bottom': '2px solid #777' });
      return true;
    }
  }

  function checkemail() {
    var emailReg = /^[a-zA-Z0-9.!#$%&Ã¢â‚¬â„¢*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;
    if (!emailReg.test($('#donate_email').val())) {
      $('#donate_email').css({ 'border-bottom': '2px solid red' });
      return false;
    } else {
      $('#donate_email').css({ 'border-bottom': '2px solid #777' });
      return true;
    }
  }

  function checkphonenumber(){
    if ($('#phone_number').val() == '') {
      $('#phone_number').css({ 'border-bottom': '2px solid red' });
      return false;
    } else {
      $('#phone_number').css({ 'border-bottom': '2px solid #777' });
      return true;
    }
  }

  function checkdonationamount(){
    if ($('#donation_amount').val() == '') {
      $('#donation_amount').css({ 'border-bottom': '2px solid red' });
      return false;
    } else {
      $('#donation_amount').css({ 'border-bottom': '2px solid #777' });
      return true;
    }
  }

  function checkpancardnumber() {
    if ($('#pan_card_number').val() == '') {
      $('#pan_card_number').css({ 'border-bottom': '2px solid red' });
      return false;
    } else {
      $('#pan_card_number').css({ 'border-bottom': '2px solid #777' });
      return true;
    }
  }

  function checkcertificatename() {
    if ($('#certificate_name').val() == '') {
      $('#certificate_name').css({ 'border-bottom': '2px solid red' });
      return false;
    } else {
      $('#certificate_name').css({ 'border-bottom': '2px solid #777' });
      return true;
    }
  }

  function checkrecepientname() {
    if ($('#recepient_name').val() == '') {
      $('#recepient_name').css({ 'border-bottom': '2px solid red' });
      return false;
    } else {
      $('#recepient_name').css({ 'border-bottom': '2px solid #777' });
      return true;
    }
  }


});
// Donation Page Form Ends