<?php

namespace App\Http\Controllers;

use App\Rules\MatchOldPassword;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\User;
use DNS2D ;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Hash;
use App\Models\TransactionDetails;

class AdminController extends Controller
{

    public function __construct() {
        $this->middleware('web', ['except' => ['login', 'postLogin', 'changePassword','postChangePassword','dashboard']]);
    }


    public function login() {
        if(Auth::user()){
            return redirect('admin/dashboard');
        }
        return view('admin.login');
    }

    public function changePassword() {
        return view('admin.change_password');
    }
    public function postChangePassword(Request $request) {

        $request->validate([
            'current_password' => ['required', new MatchOldPassword],
            'new_password' => ['required'],
            'confirm_new_password' => ['same:new_password'],
        ]);

        // $messages = [
        //     'new_confirm_password.same' => 'Password Confirmation should match the Password',
        // ];
        User::find(auth()->user()->id)->update(['password'=> Hash::make($request->new_password)]);
   
        Auth::logout();
        return redirect('admin/login');
    }


    public function dashboard(){
        if(!Auth::user()){
            return redirect('admin/login');
        }
        //donation_id
        $t_dtls = DB::table('transaction_details')
                    ->leftJoin('contact_details','transaction_details.donation_id','=','contact_details.donation_id')
                    ->get();
        return view('admin.admin-dashboard',compact('t_dtls'));
    }
    public function transDetails(Request $request){
        $t_dtls = DB::table('transaction_details')
                    ->leftJoin('contact_details','transaction_details.donation_id','=','contact_details.donation_id')
                    ->get();
        return response()->json(['data'=> $t_dtls,'status' => '200', 'message' => 'done']);
    }
    public function transactionPaginate(Request $request){
       
                $table = 'transaction_details';
 

                $primaryKey = 'transaction_details.donation_id';
 

        $columns = array(
            array( 'db' => 'first_name', 'dt' => 0 ),
            array( 'db' => 'last_name',  'dt' => 1 ),
            array( 'db' => 'email',   'dt' => 2 ),
            array( 'db' => 'mobile',     'dt' => 3 ),
            array( 'db' => 'amount',     'dt' => 4 ),
            array( 'db' => 'currency',     'dt' => 5 ),
            array( 'db' => 'transaction_status',     'dt' => 6 ),
            array(
                'db'        => "d_id",
                'dt'        => 7,
                'formatter' => function( $d, $row ) {
                    //   return '<a id="exampleModalLong" href ="#'.$d.'" class="detail_modul">Details</a>';
                    return '<a  href="/details-view/'.$d. '" id="detail_modul" data-id="'.$d.'" class="btn btn-primary ">View Details </a>';
                    
                }
                
            ),
        );
 
        // SQL server connection information
        $sql_details = array(
            'user' => env('DB_USERNAME'),
            'pass' => env('DB_PASSWORD'),
            'db'   => env('DB_DATABASE'),
            'host' => env('DB_HOST')
        );
        
    //    require __DIR__ . '/ssp.php';

        
        echo json_encode(
            PsssController::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
        );


        // $t_dtls = DB::table('transaction_details')
        //             ->leftJoin('contact_details','transaction_details.donation_id','=','contact_details.donation_id')
        //             ->get();
        // return response()->json(['status' => '200', 'message' => 'done']);
        // return view('admin.admin-dashboard',compact('t_dtls'));
    }

    public function transactionDownload(){
        $public_path= public_path();
        $public_path .= '/dowload_transaction.csv';

        if(file_exists($public_path)){
            //unlink($public_path);
        }
        $file = fopen($public_path, "w") or die("Unable to open file!");
        $header = array(
            'FirstName','LastName','email','Country Code','Mobile','Amount','Pan Card','Currency','Cheque details','Certificate Name','Personal Message','Receipt Date','Receipt Number','address','donar_type',
            'donar Currency','Other','Responce Code','Gateway Message','Gateway Transaction Id','Gateway Auth Code','Bank Reference Number','Order Id','Tracking Id','Transaction Status','Transaction Date Time','Transaction Ip Adderess','Updated At','Created At'
        );

    fputcsv($file,$header);
    $t_dtls = DB::table('transaction_details')
    ->leftJoin('contact_details','transaction_details.donation_id','=','contact_details.donation_id')
    ->get();

    foreach($t_dtls as $t_dtl){
        $rows=array(
            $t_dtl->first_name,$t_dtl->last_name,$t_dtl->email,$t_dtl->country_code,$t_dtl->mobile,$t_dtl->amount,$t_dtl->pan_card,$t_dtl->currency,$t_dtl->cheque_details,$t_dtl->certificate_name,$t_dtl->personal_message,$t_dtl->receipt_date,$t_dtl->receipt_number,$t_dtl->address,$t_dtl->donar_type,$t_dtl->donar_currency,$t_dtl->other,$t_dtl->gateway_responce_code,$t_dtl->gateway_message,$t_dtl->gateway_transaction_id,$t_dtl->gateway_auth_code,$t_dtl->bank_reference_number,$t_dtl->order_id,$t_dtl->trackingId,$t_dtl->transaction_status,$t_dtl->transaction_date_time,$t_dtl->transaction_ip_adderess,$t_dtl->updated_at,$t_dtl->created_at,$t_dtl->created_at
        );
        fputcsv($file,$rows);
    }
    fclose ($file);
    return response()->json(['status' => '200', 'message' => 'done']);
    }

    public function logout() {
        Auth::logout();
        return redirect('admin/login');
    }

    public  function  transateDetails(Request $request){
        $t_dtl = DB::table('transaction_details')
        ->leftJoin('contact_details','transaction_details.donation_id','=','contact_details.donation_id')
        ->where('transaction_details.donation_id','=',$request->id)
        ->first();
        return view('admin.detail-view',compact('t_dtl'));

    }


    public function postLogin(Request $request) {
        if(Auth::user()){
            return redirect('admin/dashboard');
        }else{
        $validate = validator($request->all(), [
            'email' => 'required|email',
            'password' => 'required'
        ]);
        
        if ($validate->fails()) {
            return back()->withErrors($validate)->withInput();
        }
       
        $credentials = ['email' => filter_var($request->get('email'),FILTER_SANITIZE_EMAIL), 'password' => $request->get('password')];
        $loginAttempt = Auth::attempt($credentials);

        if ($loginAttempt) {
            return redirect('admin/dashboard');
        }
        $notification = array(
            'message' => 'Whoops! There were some problems with your input.Invalid credentials.',
            'alert-type' => 'error'
        );
        return back()->with($notification);
        }
    }
   
   
   
    //this form impplement the volunteer form on home page 
    function checkGoogleKey($key){
        $secretKey = env('GOOGLE_RECAPTCHA_SECRET_KEY');

        $url =  'https://www.google.com/recaptcha/api/siteverify?secret=' . urlencode($secretKey) .  '&response=' . urlencode($key);
        $response = file_get_contents($url);
        $responseKeys = json_decode($response,true);
        // header('Content-type: application/json');
        if($responseKeys["success"]) {
            return true;
        } else {
            
            return false;
        }
    }
    public function submit_func(Request $request)
    {
        $post = $request->all();
        $responce = [];
        $responce['success'] = false;
        $responce['message'] = 'Something went wrong';
        if (!$this->checkGoogleKey($post['g-recaptcha-response'])) {
            return response()->json($responce);
        }

        $jsonData = [
            "title" => !empty($request->title) ? $request->title : "",
            "ticket_details" => isset($request->message) ? $request->message :  "",
            "due_date" => "",
            "customer_name" =>  $request->name,
            "phone" => $request->phone,
            "email_id" => $request->email,
        ];
        // echo " >> ";
        // echo "<pre>"; print_r( $jsonData ); die();


        $header = array();
        $ch = curl_init();

        // Set the URL
        curl_setopt($ch, CURLOPT_URL, "https://nuhospitals.kapturecrm.com/add-ticket-from-other-source.html/v.2.0");

        // Set the HTTP headers
        $headers = [
            'Content-Type: application/json',
            'Authorization: Basic cGp0emU2bWEwZHJpenBxaDE5ZXljZmFyNnhpbHE2dTNtbm4yaXp6bjVmeGxkN2RycHA=',
        ];

        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);

        // Convert JSON data to a string
        $jsonString = json_encode($jsonData);
         
        // Set the JSON data as the request body
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Execute the cURL request
        $server_output = curl_exec($ch);
        //dd($server_output); 
        $server_output = json_decode($server_output, true);
        // echo "<pre>";  print_r($server_output);  die;
        if (curl_error($ch)) {

            curl_close($ch);
            if (!empty($server_output['status']) && $server_output['status'] == 'success') {
                $responce['success'] = true;
                $responce['message'] = 'we will be in touch soon to confirm your appointment time';
            }
        } else {

            curl_close($ch);
            if (!empty($server_output['status']) && $server_output['status'] == 'success') {
                $responce['success'] = true;
                $responce['message'] = 'we will be in touch soon to confirm your appointment time';
            }
        }
        return response()->json($responce);
    }
}
