<?php

require_once __DIR__ . '/bootstrap/bootstrap.php';


$page_title       = "IVF & IUI Treatment | NU Fertility - Personalized Care for Your Family Journey";
$page_description = "At NU Fertility, we offer expert IVF and IUI treatments tailored to your needs. Join us in your journey to parenthood with compassionate care and advanced technology.";

$current_url = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

?>


<!-- Starter Template for Bootstrap 4 -->

<!doctype html>
<html lang="en">

<head>

  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-H0SBYDGMS4"></script>
  <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
      dataLayer.push(arguments);
    }
    gtag('js', new Date());

    gtag('config', 'G-H0SBYDGMS4');
  </script>



  <script src="https://www.google.com/recaptcha/api.js" async defer></script>

  <link rel="stylesheet" href="popup/style.css" type="text/css">
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <!-- Page Meta Values -->
  <title><?php echo $page_title; ?></title>
  <meta name="description" content="<?php echo $page_description ?>">
  <link rel="canonical" href="<?php echo $app->app_url; ?>" />

  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
  <link rel="stylesheet" href="<?php echo $app->app_url ?>assets/css/owl/owl.carousel.min.css">
  <link rel="stylesheet" href="<?php echo $app->app_url ?>assets/css/owl/owl.theme.green.min.css">
  <link rel="stylesheet" href="<?php echo $app->app_url ?>assets/css/app.css">
  <!-- Favicons -->
  <link rel="shortcut icon" href="" type="image/x-icon" />
  <meta name="robots" content="noindex">

  <!-- Global site tag (gtag.js) - Google Analytics -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=UA-109850032-1"></script>
  <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
      dataLayer.push(arguments);
    }
    gtag('js', new Date());

    gtag('config', 'UA-109850032-1');
  </script>

  <script async defer src="https://tools.luckyorange.com/core/lo.js?site-id=8cbf0ed7"></script>

  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=AW-16829013004"></script>
  <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
      dataLayer.push(arguments);
    }
    gtag('js', new Date());

    gtag('config', 'AW-16829013004');
  </script>


</head>
<style>
  body {
    letter-spacing: 0.4px !important;
  }

  .font-400 {
    font-weight: 400 !important;
  }
</style>

<body>

  <!-- Header Starts -->
  <nav class="p-1 shadow">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-4">
          <img src="<?php echo $app->app_url ?>assets/images/NU-logo.jpg" alt="Logo" height="120" />
        </div>
        <div class="col-md-5"></div>
        <div class="col-md-3">

          <a href="#form-section" class="btn btn-primary btn-block">BOOK AN APPOINTMENT</a>

        </div>
      </div>
    </div>

  </nav>
  <!-- Header Ends -->

  <!-- Banner Starts -->
  <section class="section  p-0 bg-gray-dark">
    <div class="container">

      <div class="row align-items-center ">

        <div class="col-md-8 banner-section banner-content">
          <h1 class="mb-0 text-secondary mb-3">The Journey<br>
            to Parenthood</h1>
          <h3 class="mb-0 text-gray mb-3 font-40"> Finding the<br>
            Best IVF Centre<br>
            in Bangalore</h3>

        </div>

        <div class="col-md-4 bg-light p-3 rounded" id="form-section">

          <h5 class="text-primary font-700 text-center mb-4">BOOK AN APPOINTMENT</h5>
          <form action="<?php echo $app->app_url; ?>thank-you.php" method="post" id="landing-form" class="">
            <div class="form-group">
              <input type="hidden" name="name" style="display: none;">
              <input type="text" name="full_name" id="full_name" placeholder="Full Name" class="form-control">
            </div>
            <div class="form-group">
              <input type="email" name="email" id="email" placeholder="Email ID" class="form-control">
            </div>
            <div class="form-group">
              <input type="text" name="phone" id="phone" placeholder="Mobile No" class="form-control">
            </div>

            <div class="form-group">
              <textarea name="message" id="message" rows="2" placeholder="Message" class="form-control"></textarea>
            </div>

            <div class="form-group text-right mb-0 mt-3">
              <input type="hidden" name="form_name" value="NU Fertility LP">
              <input type="hidden" name="form_url" value="<?php echo $current_url; ?>">
              <input type="hidden" name="utm_source" value="<?php echo htmlspecialchars($_GET['utm_source'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
              <input type="hidden" name="utm_medium" value="<?php echo htmlspecialchars($_GET['utm_medium'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
              <input type="hidden" name="utm_campaign" value="<?php echo htmlspecialchars($_GET['utm_campaign'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
              <input type="hidden" name="utm_id" value="<?php echo htmlspecialchars($_GET['utm_id'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
              <div class="form-group col-md-12">
                <div class="g-recaptcha" data-sitekey="6LcfcwIqAAAAADj7R3Efv3En-rejtQJFCtaSWyWH" style="transform:scale(0.7);-webkit-transform:scale(0.7);transform-origin:0 0;-webkit-transform-origin:0 0;"></div>
              </div>
              <button type="submit" class="btn btn-primary  btn-block font-700  " id="landing-submit">Submit</button>
            </div>
          </form>
        </div>
      </div>

    </div>
  </section>
  <!-- Banner Ends -->



  <!-- benefits Starts -->
  <section class="section">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-6">
          <h5 class="text-primary font-700">Insurance/TPA Available. Get a Free Estimation Today</h5>
          <h5>Facing infertility issues like failed IVF, unexplained
            infertility etc can be an emotional and challenging
            journey. At NU Fertility, we understand your dreams
            of parenthood and make your wish come true. We are
            committed to provide personalized care, through
            using advanced technology and a team of expert
            specialists to help couples achieve your parenthood
            dream.</h5>
        </div>
        <div class="col-md-6">
          <img src="<?php echo $app->app_url; ?>assets/images/ivf-journey.png" alt="" class="img-fluid rounded " width="100%" height="auto">
        </div>
      </div>
    </div>
  </section>
  <!-- benefitsEnds -->

  <!-- count Starts -->
  <section class="section p-0" style="background-color:#dce8ea;">
    <div class="container">
      <div class="row text-center  rounded">
        <div class="col count p-3 border-r">
          <img src="<?php echo $app->app_url; ?>assets/images/i1.png" alt="" class="img-fluid rounded " width="35%" height="auto">
          <h2 class="">20+</h2>
          <h5 class=" ">Yrs of Experience</h5>
        </div>
        <div class="col count p-3 border-r">
          <img src="<?php echo $app->app_url; ?>assets/images/i2.png" alt="" class="img-fluid rounded " width="35%" height="auto">
          <h2 class="">4000+</h2>
          <h5 class=" ">Live Births Babies</h5>
        </div>
        <div class="col count p-3 border-r">
          <img src="<?php echo $app->app_url; ?>assets/images/i3.png" alt="" class="img-fluid rounded " width="35%" height="auto">
          <h2 class="">10000+</h2>
          <h5 class=" ">Happy Families</h5>
        </div>
        <div class="col count p-3 border-r">
          <img src="<?php echo $app->app_url; ?>assets/images/i4.png" alt="" class="img-fluid rounded " width="35%" height="auto">
          <h2 class="">75%+</h2>
          <h5 class="">Success Rate</h5>
        </div>
      </div>
    </div>
  </section>
  <!-- count Ends -->



  <!-- why choose Starts -->
  <section class="section">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-12">
          <h2 class="text-secondary mb-4">Why Choose NU Fertility as Your IVF Centre in Bangalore?</h2>
          <h5>When you plan to visit the best IVF center in Bangalore, you need a team who understands your needs, has the latest
            expertise, and offers better care along with support. At NU Fertility we provide all these:</h5>
          <ul class="ft-20 ">
            <li> Transparency and accuracy in infertility treatment methodology</li>
            <li> Advanced & comprehensive diagnosis to detect the root cause of infertility</li>
            <li> Our treatment methodology aims at the success in treatment, regardless of age or the reasons of infertility</li>
            <li> Regular research to keep up with new methods and techniques of IVF treatment</li>
            <li> Centralized monitoring system for A/C’s in OT, IVF Lab and Lab to maintain temperature, humidity and pressure</li>
            <li> Provide the best technological support in IVF procedure</li>
            <li> NABH & ISAR accredited centre</li>
            <li> Support the couples end to end providing a consistent therapy untill success is achieved</li>
            <li> Use of CCTV monitoring for clinical quality monitoring eg: Hand hygiene monitoring</li>
            <li> Protocol based Systematic Treatment - All under One Roof</li>
          </ul>
        </div>
      </div>
      <div class="row align-items-center mt-4">
        <div class="col-md-3">
          <img src="<?php echo $app->app_url; ?>assets/images/Experienced-Experts.png" alt="" class="img-fluid rounded " width="100%" height="auto">
        </div>
        <div class="col-md-9">
          <h4 class="text-blue font-600">Experienced Experts:</h4>
          <p class="font-500 ft-20">Our team of highly qualified male & female fertility specialists, uro andrologist, experienced embryologists and compassionate nurses, are committed to providing
            utmost care. We listen and understand your concerns, and will answer all your queries,
            and will guide you through every step of the process.</p>
        </div>
      </div>

      <div class="row align-items-center mt-4 rev">
        <div class="col-md-9">
          <h4 class="text-blue font-600">Latest Technology and Infrastructure :</h4>
          <p class="font-500 ft-20">NU Fertility is equipped with state-of-art facilities and equipped with the latest technology
            IVF Laboratory with bioclad walls which are antimicrobicidal, ensuring IVF treatments with highest success rates. Our hospital is designed and created to provide passionate & personalized care and a best in class environment for the best patient experience.</p>
        </div>
        <div class="col-md-3">
          <img src="<?php echo $app->app_url; ?>assets/images/Technology-Infrastructure.png" alt="" class="img-fluid rounded " width="100%" height="auto">
        </div>
      </div>


      <div class="row align-items-center mt-4">
        <div class="col-md-3">
          <img src="<?php echo $app->app_url; ?>assets/images/Success-Rates1.png" alt="" class="img-fluid rounded " width="100%" height="auto">
        </div>
        <div class="col-md-9">
          <h4 class="text-blue font-600">Success Rates:</h4>
          <p class="font-500 ft-20">We are best in our consistency with a high success rate in IVF treatments, which is an
            example for our experts and latest tech. We treat research based practices and focus on
            patient well-being throughout the parenthood journey.</p>
        </div>

      </div>

      <div class="row align-items-center mt-4 rev">
        <div class="col-md-9">
          <h4 class="text-blue font-600">Options In Treatment:</h4>
          <p class="font-500 ft-20">Every couple is special to us, we understand it. That is the reason we provide personalized
            treatment options, catered for specific goals and needs. We will take time to understand patients' medical history, lifestyle, and hope to create a treatment path for a successful parent journey</p>
        </div>
        <div class="col-md-3">
          <img src="<?php echo $app->app_url; ?>assets/images/Options-In-Treatment1.png" alt="" class="img-fluid rounded " width="100%" height="auto">
        </div>
      </div>
      <div class="row align-items-center mt-4">
        <div class="col-md-3">
          <img src="<?php echo $app->app_url; ?>assets/images/Support-Care.png" alt="" class="img-fluid rounded " width="100%" height="auto">
        </div>
        <div class="col-md-9">
          <h4 class="text-blue font-600">Support and Care:</h4>
          <p class="font-500 ft-20">At NU Fertility, we believe emotional well-being is just as important as the treatment process. We provide a safe environment, along with guidance, encouragement, and holistic care. We are your compassionate listeners in your journey to parenthood.</p>
        </div>

      </div>



    </div>
  </section>
  <!-- why choose Ends -->

  <!-- solutions Starts -->
  <section class="section bg-primary">
    <div class="container ">
      <div class="row">
        <div class="col-md-8 text-white">
          <h2 class="text-white">NU Fertility: Your Fertility Solution in Bangalore</h2>
          <h5><span class="font-700">Searching for the best IVF centers in Bangalore? </span>Nu Fertility provides a
            wide range of fertility services to help parents facing
            infertility problems achieve their dream of parenthood.</h5>
          <h5><span class="font-700">Industry-leading IVF treatment,</span> we provide a personalized approach to fertility
            care, designed to your individual needs.</h5>
          <h5 class="font-700">Our Comprehensive Services Include:</h5>
        </div>
        <div class="col-md-4">
          <img src="<?php echo $app->app_url; ?>assets/images/services-ivf.png" alt="" class="img-fluid rounded img-solu " width="100%" height="auto">
        </div>
      </div>

      <div class="row align-items-center text-center ">
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Female & Male Fertility Evaluation
              & Treatment :</h3>

            <p class="mb-4 font-400">We offer complete fertility care with
              personalised assessments to understand
              and treat the challenges you are facing
              in the parenthood path.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Egg / Sperm / Embryo Freezing:</h3>

            <p class="mb-4 font-400">Our fertility preserving methods wil put you
              at ease if you are planning to get pregnant in
              the future or undergoing medical treatment
              which will help you in preserving fertility as
              per your needs.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Female & Male Sexual Health:</h3>

            <p class="mb-4 font-400">an important factor of fertility is your sexual
              health, we provide tailored treatments for
              your unique needs and ensure both you and
              your partner feel supported.</p>

          </div>
        </div>


        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Pelvic Ultrasound & Follicular Monitoring:</h3>

            <p class="mb-4 font-400">We use advanced ultrasounds to closely
              monitor your reproductive health, which
              helps you to track your ovulation and plan
              treatments accordingly.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Hormonal Assays:</h3>

            <p class="mb-4 font-400">With our comprehensive hormone testing,
              we make sure every aspect of your
              reproductive health is balanced and gives
              you the best chance of conception.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Ovulation Induction:</h3>

            <p class="mb-4 font-400">If your natural occurrence of ovulation is
              affected by various reasons, our experts will
              assist you with safe and effective medication
              to help you ovulate naturally.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Intrauterine Insemination (IUI):</h3>

            <p class="mb-4 font-400">If you are looking for a less invasive option,
              our IUI procedure could be the perfect
              solution, giving you a gentle nudge towards
              achieving your dream family.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">IVF / ICSI:</h3>

            <p class="mb-4 font-400">With our industry-leading IVF and ICSI
              treatments, we bring our cutting-edge
              technology and compassionate care to make
              your journey to parenthood as smooth as
              possible.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Frozen Embryo Transfer:</h3>

            <p class="mb-4 font-400">If you have already frozen embryos, our
              expert team will handle every step of the
              process to get you the best chance of
              storage and transfer facilitating better
              pregnancy.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Microscopic Varicocelectomy:</h3>

            <p class="mb-4 font-400">For men facing fertility issues due to
              varicocele, our advanced microscopic
              varicocelectomy can improve sperm quality
              and boost your chances of conception.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Surgical Sperm Retrieval
              (TESE / PESA / Micro TESE)</h3>

            <p class="mb-4 font-400">when a man’s body fail to produce sperm,
              we offer specialised procedures to retrieve
              sperm and renew your hope of fatherhood.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Egg Donation / Sperm Donation:</h3>

            <p class="mb-4 font-400">Through our thoroughly screened donor
              program, we offer you to build your family
              with the help of donated eggs or sperm with
              compassionate expert care.</p>

          </div>
        </div>

        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Fertility Preservation for Cancer Patients:</h3>

            <p class="mb-4 font-400">Are you facing Cancer treatment? We’re here
              to support you in preserving your fertility
              options with safe and dependable solutions
              before your treatment begins.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Laparoscopic & Hysteroscopic Surgeries:</h3>

            <p class="mb-4 font-400">Our minimally invasive surgeries offer precise
              care for diagnosing and treating fertility
              related conditions with very less hospital
              stays and discomfort.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Robotic Surgeries:</h3>

            <p class="mb-4 font-400">At NU Fertility, we use state-of-the-art
              robotic technology to perform complex
              reproductive surgeries which provides
              greater accuracy, and increases your
              chances of success.</p>

          </div>
        </div>
        <div class="col-md-4  p-2">
          <div class="bg-white rounded p-3 services">
            <h3 class="font-700 mb-2">Cosmetic Gynaecology:</h3>

            <p class="mb-4 font-400">We understand that feeling confident in your
              body is important. Our cosmetic
              gynaecology services are designed to help
              you feel your best, both physically and
              emotionally.</p>

          </div>
        </div>

        <div class="col-md-4  p-2">
          <a class="btn btn-secondary text-white font-700 " href="#form-section">BOOK AN APPOINTMENT</a>
        </div>
      </div>
      <div class="row">
        <div class="col-md-12 text-white">
          <p class="font-700">Each service at NU Fertility is designed with your unique journey in mind, and we’re here to support you every step of the way!</p>
        </div>
      </div>
    </div>
  </section>
  <!-- solutions Ends -->

  <!--  incurence Starts -->
  <section class="section bg-light">
    <div class="container ">

      <div class="row  ">
        <div class="col-md-12 mb-4 text-center">
          <h2 class="text-secondary mb-4">Insurance/TPA Available</h2>
          <a class="btn btn-secondary text-white font-700 " href="#form-section">BOOK AN APPOINTMENT</a>
        </div>
      </div>
      <!--   <div class="row  row-cols-3 row-cols-lg-5 g-2 g-lg-4  pt-4">

               <div class="owl-carousel owl-theme" id="logo-carousel">
                    
                    
                    <div class="item">
                       <img src="<?php echo $app->app_url; ?>assets/images/Bharti-AXA1.jpg" class="img-fluid ">
                       
                    </div> 
                        <div class="item">
                       <img src="<?php echo $app->app_url; ?>assets/images/Birla1.jpg" class="img-fluid ">
                    </div>
                      <div class="item">
                        <img src="<?php echo $app->app_url; ?>assets/images/Chola1.jpg" class="img-fluid ">
                        </div>
                    <div class="item">
                        <img src="<?php echo $app->app_url; ?>assets/images/Ericson-Insurance1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                        <img src="<?php echo $app->app_url; ?>assets/images/ICICI-Lombard1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                        <img src="<?php echo $app->app_url; ?>assets/images/Liberty-GI1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                       <img src="<?php echo $app->app_url; ?>assets/images/Med-Save1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                        <img src="<?php echo $app->app_url; ?>assets/images/Paramount-Health1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                       <img src="<?php echo $app->app_url; ?>assets/images/Royal-Sundaram1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                        <img src="<?php echo $app->app_url; ?>assets/images/Safeway-Insurance1.jpg" class="img-fluid">
                    </div> 
                   <div class="item">
                       <img src="<?php echo $app->app_url; ?>assets/images/TATA-AIG1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                         <img src="<?php echo $app->app_url; ?>assets/images/Kotak1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                        <img src="<?php echo $app->app_url; ?>assets/images/magma1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                      <img src="<?php echo $app->app_url; ?>assets/images/navi1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                        <img src="<?php echo $app->app_url; ?>assets/images/sbi1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                       <img src="<?php echo $app->app_url; ?>assets/images/Edelweiss1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                         <img src="<?php echo $app->app_url; ?>assets/images/East-west-assist-tpa1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                       <img src="<?php echo $app->app_url; ?>assets/images/acko1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                        <img src="<?php echo $app->app_url; ?>assets/images/26-universalsompo1.jpg" class="img-fluid">
                    </div> 
                   <div class="item">
                      <img src="<?php echo $app->app_url; ?>assets/images/vidal1.jpg" class="img-fluid">
                    </div> 
                   <div class="item">
                       <img src="<?php echo $app->app_url; ?>assets/images/star_health_logo_big1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                       <img src="<?php echo $app->app_url; ?>assets/images/realine1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                       <img src="<?php echo $app->app_url; ?>assets/images/ma-tpa-logo1.jpg" class="img-fluid">
                    </div> 
                   <div class="item">
                      <img src="<?php echo $app->app_url; ?>assets/images/future-generali1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                        <img src="<?php echo $app->app_url; ?>assets/images/FHPL1.jpg" class="img-fluid ">
                    </div> 
                   <div class="item">
                       <img src="<?php echo $app->app_url; ?>assets/images/16-Allied Insurance1.jpg" class="img-fluid">
                    </div> 
                   <div class="item">
                       <img src="<?php echo $app->app_url; ?>assets/images/go-digit1.jpg" class="img-fluid ">
                    </div> 
                  
              </div> 
             
        
           
         </div> -->


    </div>
  </section>
  <!-- incurence  Ends -->

  <!-- understand Starts -->
  <section class="section">
    <div class="container">
      <div class="row align-items-center rounded" style="background-color:#79a588;">

        <div class="col-md-8 text-white">
          <h5 class="font-700">Understanding Your Concerns:</h5>
          <h5>We understand going through infertility can be overwhelming.
            At NU Fertility, our team of highly experienced fertility specialists in
            Bangalore and shivamogga, which includes experienced specialists,
            trained embryologists, and nurses, which as a team dedicated in
            providing you with utmost care and support throughout the journey</h5>
        </div>
        <div class="col-md-4 p-0">
          <img src="<?php echo $app->app_url; ?>assets/images/understanding.png" alt="" class="img-fluid rounded " width="100%" height="auto">
        </div>
      </div>

    </div>
  </section>
  <!-- understand Ends -->



  <!-- team Starts -->
  <section class="section ">
    <div class="container ">
      <div class="row">
        <div class="col-md-12 mb-4">
          <h2 class="text-secondary text-center">Our Expert Team of Fertility</h2>
        </div>
      </div>
      <div class="row align-items-center text-center ">
        <div class="col-md-2"></div>
        <div class="col-md-4  p-4">
          <div class="bg-gray rounded p-3 dr">

            <img src="<?php echo $app->app_url; ?>assets/images/dr.sneha.png" alt="" class="img-fluid rounded mb-4" width="50%" height="auto">
            <h4 class="font-700 ">Dr. Sneha J</h4>
            <p class="mb-4">MBBS,MD (OBG) AIIMS,DNB (OBG), FIRM (Fellowship in Reproductive Medicine)</p>
            <p class="mb-4">Sr. Consultant- IVF Specialist & Gynaecologist</p><br /><br />
            <div class="text-center"> <a class="btn btn-primary text-white font-700 " href="#form-section">BOOK AN APPOINTMENT</a></div>
          </div>
        </div>

        <div class="col-md-4  p-4">
          <div class="bg-gray rounded p-3 dr">

            <img src="<?php echo $app->app_url; ?>assets/images/dr.pramod.png" alt="" class="img-fluid rounded mb-4" width="50%" height="auto">
            <h4 class="font-700 ">Dr. Pramod Krishnappa</h4>
            <p class="mb-4">MBBS,MS (General Surgery), DNB (Urology),
              Chm Urology (Edinburgh, UK )</p>
            <p class="mb-4">Consultant- Andrologist</p><br /><br />
            <div class="text-center"> <a class="btn btn-primary text-white font-700 " href="#form-section">BOOK AN APPOINTMENT</a></div>
          </div>
        </div>

        <div class="col-md-2"></div>
      </div>

    </div>
  </section>
  <!-- team Ends -->

  <!-- Testimonials Starts -->
  <section class="section bg-secondary">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-4 ">
          <h2 class="font-700 text-white mb-4">Patient Testimonials</h2>
        </div>
        <div class="col-md-8 bg-gray rounded">
          <div class="owl-carousel owl-theme" id="testimonial-carousel">


            <div class="item">
              <div class="item p-5">
                <div class="col-md-12 p-4 bg-gray rounded ">
                  <h3 class="text-primary">Chaitra shashi</h3>
                  <h5>We had a great experience at NU hospital.The staff was friendly
                    and professional, and the facilities were clean and modern. We had
                    consultation for my pregnancy with Dr Sneha J and I couldn't be
                    more pleased with the experience. She listens to our questions with
                    patience and answer them.</h5>

                </div>
              </div>

            </div>
            <div class="item">
              <div class="item p-5">
                <div class="col-md-12 p-4 bg-gray rounded ">
                  <h3 class="text-primary">Fathun Nahu</h3>
                  <h5> went so many hospitals. From all the hospitals this hospital is the best one i went.. In here all the staffs, nurses and doctors are the best peoples.. I got so much care and i didn't felt that this is a hospital but felt like a home... All of the staffs are so helpful... </h5>

                </div>
              </div>

            </div>
            <div class="item p-5">
              <div class="col-md-12 p-4 bg-gray rounded ">
                <h3 class="text-primary">Rajesh R Nair</h3>
                <h5>I had wonderful experience at Nu fertility. The staff was caring throughout my entire journey. The facilities were clean and comfortable and very supportive. Dr Sneha was supportive and knowledgeable doctor thank you so much.</h5>

              </div>
            </div>

          </div>
        </div>
      </div>

    </div>
  </section>
  <!-- Testimonials Ends -->



  <!--  Starts -->
  <section class="section">
    <div class="container ">
      <div class="row">
        <div class="col-md-12 mb-4">
          <h2 class="text-secondary text-center">Frequently Asked Questions</h2>
        </div>
      </div>
      <div class="row ">
        <div class="col-md-12">
          <div class="bg-primary p-3 mb-2 text-white rounded">
            <h5 class="font-700">Success rates in IVF?</h5>
            <h5>During your consultation, we'll discuss specific conditions and situations along with potential outcomes.
              Success may vary based on individual factors.</h5>
          </div>
          <div class="bg-primary p-3 mb-2 text-white rounded">
            <h5 class="font-700">What will be the IVF cost?</h5>
            <h5>During your initial consultation we provide you a transparent price and breakdown of cost.</h5>
          </div>
          <div class="bg-primary p-3 mb-2 text-white rounded">
            <h5 class="font-700">What are the steps involved in IVF?</h5>
            <h5>Typically the IVF process involves ovarian stimulation, egg retrieval, fertilization, embryo transfer, and pregnancy
              monitoring. We will help you understand every step of the process in detail.</h5>
          </div>
          <div class="bg-primary p-3 mb-2 text-white rounded">
            <h5 class="font-700">What are the risks and side effects of IVF?</h5>
            <h5>Like many medical treatments, IVF comes with a bit of complications. We'll explain the details during your initial
              consultation and answer all your concerns which you have.</h5>
          </div>

        </div>



      </div>

    </div>
  </section>
  <!--  Ends -->


  <!-- planning Starts -->
  <section class="section ">
    <div class="container ">

      <div class="row align-items-center ">
        <div class="col-md-8 ">
          <h3 class="font-700 text-secondary mb-4">Planning Your Journey to Parenthood?</h3>
          <p class="ft-20">At NU Fertility, one of the best infertility clinics in Bangalore, we provide
            dedicated support on your journey to parenthood. <br><br>
            Schedule a consultation with our IVF specialists today. We are here to
            listen and answer all your queries, and help you to build a family which
            you dreamt always help you build the family you've always envisioned.</p>
        </div>

        <div class="col-md-4  p-4">
          <div class="bg-gray rounded p-3 dr ">
            <h5 class="text-primary font-700 text-center mb-4">BOOK AN APPOINTMENT</h5>
            <form action="<?php echo $app->app_url; ?>thank-you.php" method="post" id="landing-form" class="">
              <div class="form-group">
                <input type="hidden" name="name" style="display: none;">
                <input type="text" name="full_name" id="full_name" placeholder="Full Name" class="form-control" required>
              </div>
              <div class="form-group">
                <input type="email" name="email" id="email" placeholder="Email ID" class="form-control" required>
              </div>
              <div class="form-group">
                <input type="text" name="phone" id="phone" placeholder="Mobile No" class="form-control" required>
              </div>

              <div class="form-group">
                <textarea name="message" id="message" rows="2" placeholder="Message" class="form-control"></textarea>
              </div>

              <div class="form-group text-right mb-0 mt-3">
                <input type="hidden" name="form_name" value="NU Fertility LP">
                <input type="hidden" name="form_url" value="<?php echo $current_url; ?>">
                <input type="hidden" name="utm_source" value="<?php echo htmlspecialchars($_GET['utm_source'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                <input type="hidden" name="utm_medium" value="<?php echo htmlspecialchars($_GET['utm_medium'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                <input type="hidden" name="utm_campaign" value="<?php echo htmlspecialchars($_GET['utm_campaign'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                <input type="hidden" name="utm_id" value="<?php echo htmlspecialchars($_GET['utm_id'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                <div class="form-group col-md-12">
                  <div class="g-recaptcha" data-sitekey="6LcfcwIqAAAAADj7R3Efv3En-rejtQJFCtaSWyWH" style="transform:scale(0.7);-webkit-transform:scale(0.7);transform-origin:0 0;-webkit-transform-origin:0 0;"></div>
                </div>
                <button type="submit" class="btn btn-primary  btn-block font-700  " id="landing-submit">Submit</button>
              </div>
            </form>
          </div>
        </div>


      </div>

    </div>
  </section>
  <!-- planning Ends -->

  <!--  Starts -->
  <section class="section bg-secondary">
    <div class="container ">

      <div class="row align-items-center ">
        <div class="col-md-3">

        </div>
        <div class="col-md-6 text-white p-4">
          <h5 class="mb-4 text-center font-600">NU Fertility @ <br> NU Hospitals Rajajinagar (West) <br> # 4/1, West of Chord Road, Near to ISKCON, Rajajinagar, Bengaluru, Karnataka, 560010. India</h5>
          <h5 class="mb-4 text-center"><a href="tel:8147640991" class="text-white font-700">Contact : 8147640991</a></h5>
          <div class="text-center"> <a class="btn btn-white font-700 " href="https://www.google.com/maps?client=firefox-b-d&sca_esv=5b7a4e7a7d376703&sca_upv=1&sxsrf=ADLYWIIUaPpWFD9Ar472OYJAUbtTn1wiig:1719311823995&uact=5&gs_lp=Egxnd3Mtd2l6LXNlcnAiigFOVSBGZXJ0aWxpdHkgQApOVSBIb3NwaXRhbHMgUmFqYWppbmFnYXIgKFdlc3QpCiMgNC8xLCBXZXN0IG9mIENob3JkIFJvYWQsIE5lYXIgdG8gSVNLQ09OLApSYWphamluYWdhciwgQmVuZ2FsdXJ1LCBLYXJuYXRha2EsIDU2MDAxMC4gSW5kaWFIAFAAWABwAHgAkAEAmAEAoAEAqgEAuAEDyAEA-AEC-AEBmAIAoAIAmAMAkgcAoAcA&um=1&ie=UTF-8&fb=1&gl=in&sa=X&geocode=KbGb5BaAPa47MW0YIXhAMkJr&daddr=4/1,+Chord+Rd,+near+to+ISKCON,+Rajajinagar,+Bengaluru,+Karnataka+560010" target="_blank">CLICK HERE FOR DIRECTIONS</a></div>
        </div>

        <div class="col-md-3">

        </div>

      </div>

    </div>
  </section>
  <!--  Ends -->



  <!-- Footer Starts -->
  <section class="section bg-white p-3">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-6 text-left">
          <h5 class="mb-0 text-dark font-700 text-center"> NU Fertility &copy; 2024. All Rights Reserved.</h5>
        </div>
        <div class="col-md-6 text-right">
          <h5 class="mb-0 text-dark font-700 text-center"> * ⁠T & C apply for 75% success rate</h5>
        </div>

      </div>
    </div>
  </section>
  <!-- Footer Ends -->




  <!-- Optional JavaScript -->
  <!-- jQuery first, then Popper.js, then Bootstrap JS -->
  <script src="<?php echo $app->app_url; ?>node_modules/jquery/dist/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
  <script src="<?php echo $app->app_url ?>node_modules/bootstrap/dist/js/bootstrap.min.js"></script>
  <script src="<?php echo $app->app_url; ?>assets/js/owl/owl.carousel.min.js"></script>
  <script src="<?php echo $app->app_url; ?>assets/js/app.js"></script>
  <script src="popup/script.js"></script>
</body>

</html>