<?php

require_once __DIR__ . '/bootstrap/bootstrap.php';


$page_title       = "NU IUI Hospital - NU Fertility  ";
$page_description = "";

?>


<!-- Starter Template for Bootstrap 4 -->

<!doctype html>
<html lang="en">

<head>
  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-VZW4PPF9NN"></script>
  <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
      dataLayer.push(arguments);
    }
    gtag('js', new Date());

    gtag('config', 'G-VZW4PPF9NN');
  </script>

  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-H0SBYDGMS4"></script>
  <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
      dataLayer.push(arguments);
    }
    gtag('js', new Date());

    gtag('config', 'G-H0SBYDGMS4');
  </script>


  <script src="https://www.google.com/recaptcha/api.js" async defer></script>

  <link rel="stylesheet" href="popup/style.css" type="text/css">
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <!-- Page Meta Values -->
  <title><?php echo $page_title; ?></title>
  <meta name="description" content="<?php echo $page_description ?>">
  <link rel="canonical" href="<?php echo $app->app_url; ?>" />

  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
  <link rel="stylesheet" href="<?php echo $app->app_url ?>assets/css/owl/owl.carousel.min.css">
  <link rel="stylesheet" href="<?php echo $app->app_url ?>assets/css/owl/owl.theme.green.min.css">
  <link rel="stylesheet" href="<?php echo $app->app_url ?>assets/css/app.css">
  <!-- Favicons -->
  <link rel="shortcut icon" href="" type="image/x-icon" />
  <meta name="robots" content="noindex">
</head>

<body>

  <!-- Header Starts -->
  <nav class="p-1 shadow">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-4">
          <img src="<?php echo $app->app_url ?>assets/images/NU-logo.jpg" alt="Logo" height="120" />
        </div>
        <div class="col-md-5"></div>
        <div class="col-md-3">

          <a href="#form-section" class="btn btn-primary btn-block">BOOK AN APPOINTMENT</a>

        </div>
      </div>
    </div>

  </nav>
  <!-- Header Ends -->

  <!-- Banner Starts -->
  <section class="section banner-section p-0 dsk">
    <div class="container">

      <div class="row align-items-center ">
        <div class="col-md-3"></div>
        <div class="col-md-5 banner-content text-right">
          <!--   <h1 class="mb-0 text-primary mb-3"></h1>
<h4 class="mb-0 text-orange mb-3 font-40"> </h4> -->
        </div>
        <div class="col-md-4 bg-light p-3 rounded" id="form-section">

          <h5 class="text-primary font-700 text-center mb-4">BOOK AN APPOINTMENT</h5>
          <form action="<?php echo $app->app_url; ?>thank-you.php" method="post" id="landing-form" class="">
            <div class="form-group">
              <input type="hidden" name="name" style="display: none;">
              <input type="text" name="full_name" id="full_name" placeholder="Full Name" class="form-control">
            </div>
            <div class="form-group">
              <input type="email" name="email" id="email" placeholder="Email ID" class="form-control">
            </div>
            <div class="form-group">
              <input type="text" name="phone" id="phone" placeholder="Mobile Number" class="form-control">
            </div>

            <div class="form-group">
              <textarea name="message" id="message" rows="2" placeholder="Message" class="form-control"></textarea>
            </div>

            <div class="form-group text-right mb-0 mt-3">
              <input type="hidden" name="form_name" value="NU Fertility  ">
              <input type="hidden" name="form_url" value="<?php echo $app->app_url; ?>">
              <div class="form-group col-md-12">
                <div class="g-recaptcha" data-sitekey="6LfbbgIqAAAAACd5_dAeaVyuiR5CYjhVhWLT6q4P" style="transform:scale(0.7);-webkit-transform:scale(0.7);transform-origin:0 0;-webkit-transform-origin:0 0;"></div>
              </div>
              <button type="submit" class="btn btn-primary  btn-block font-700  " id="landing-submit">Submit</button>
            </div>
          </form>
        </div>
      </div>

    </div>
  </section>
  <!-- Banner Ends -->

  <!-- Banner mobile Starts -->
  <section class="section banner-section-m p-0 d-sm-none">
    <div class="container">

      <div class="row align-items-center ">
        <div class="col-md-3"></div>
        <div class="col-md-5 banner-content text-right">
          <!--  <h1 class="mb-0 text-primary mb-3"></h1>
<h4 class="mb-0 text-orange mb-3 font-40"> </h4> -->
        </div>
      </div>

    </div>
  </section>
  <!-- Banner mobile Ends -->

  <!-- mobile formStarts -->
  <section class="section p-0 d-sm-none">
    <div class="container">
      <div class="row align-items-center ">

        <div class="col-md-4 bg-light p-3 rounded">

          <h5 class="text-primary font-700 text-center mb-4">BOOK AN APPOINTMENT</h5>
          <form action="<?php echo $app->app_url; ?>thank-you.php" method="post" id="landing-form" class="">
            <div class="form-group">
              <input type="hidden" name="name" style="display: none;">
              <input type="text" name="full_name" id="full_name" placeholder="Full Name" class="form-control">
            </div>
            <div class="form-group">
              <input type="email" name="email" id="email" placeholder="Email ID" class="form-control">
            </div>
            <div class="form-group">
              <input type="text" name="phone" id="phone" placeholder="Mobile Number" class="form-control">
            </div>

            <div class="form-group">
              <textarea name="message" id="message" rows="2" placeholder="Message" class="form-control"></textarea>
            </div>

            <div class="form-group text-right mb-0 mt-3">
              <input type="hidden" name="form_name" value="NU Fertility  ">
              <input type="hidden" name="form_url" value="<?php echo $app->app_url; ?>">
              <div class="form-group col-md-12">
                <div class="g-recaptcha" data-sitekey="6LfbbgIqAAAAACd5_dAeaVyuiR5CYjhVhWLT6q4P" style="transform:scale(0.7);-webkit-transform:scale(0.7);transform-origin:0 0;-webkit-transform-origin:0 0;"></div>
              </div>
              <button type="submit" class="btn btn-primary  btn-block font-700  " id="landing-submit">Submit</button>
            </div>
          </form>
        </div>
      </div>


    </div>
  </section>
  <!-- mobile form Ends -->


  <!-- benefits Starts -->
  <section class="section">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-12">
          <h2 class="text-secondary mb-2"> Who Benefits from IUI Treatment?</h2>

          <ul class="ft-20">

            <li> Unexplained infertility: If you've been diagnosed with unexplained infertility, IUI can often help overcome the unknown factors.</li>
            <li> Endometriosis: Combining IUI with medication can be effective for women with endometriosis by improving egg quality.</li>
            <li> Mild male infertility: IUI bypasses sperm motility issues by selecting the healthiest sperm for fertilisation.</li>
            <li> Difficulty in Sexual Intercourse: Erection problems, vaginismus, pelvic pain disorder.</li>
          </ul>
        </div>

      </div>
    </div>
  </section>
  <!-- benefitsEnds -->
  <!-- count Starts -->
  <section class="section p-0">
    <div class="container">
      <div class="row text-center bg-primary rounded">
        <div class="col count p-3 border-r">
          <h2 class="">20+</h2>
          <h5 class="text-white ">Years of Experience in Fertility</h5>
        </div>
        <div class="col count p-3 border-r">
          <h2 class="">10K+</h2>
          <h5 class="text-white ">Happy Families</h5>
        </div>
        <div class="col count p-3 border-r">
          <h2 class="">6K+</h2>
          <h5 class="text-white ">IUI CYCLE</h5>
        </div>
        <div class="col count p-3 border-r">
          <h2 class="">5K+</h2>
          <h5 class="text-white ">IVF CYCLE</h5>
        </div>
      </div>
    </div>
  </section>
  <!-- count Ends -->



  <!-- why choose Starts -->
  <section class="section">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-7">
          <h2 class="text-secondary mb-4">Why Choose NU Fertility ?</h2>
          <ul class="ft-20">
            <li> International Trained Male & Female Specialists </li>
            <li> Consistence 75% Success Rate </li>
            <li> State-Of-The-Art IVF Lab</li>
            <li> Expertise Team of Embryologists</li>
            <li> Personalised Fertility Care</li>
          </ul>
        </div>
        <div class="col-md-5">
          <img src="<?php echo $app->app_url; ?>assets/images/why-choose.jpg" alt="" class="img-fluid rounded " width="100%" height="auto">
        </div>
      </div>
    </div>
  </section>
  <!-- why choose Ends -->



  <!-- team Starts -->
  <section class="section bg-secondary ">
    <div class="container ">
      <div class="row">
        <div class="col-md-12 mb-4">
          <h2 class="text-white text-center">Our Expert Team of Specialists</h2>
        </div>
      </div>
      <div class="row align-items-center text-center ">
        <div class="col-md-6  p-4">
          <div class="bg-white p-5">
            <h2 class="font-700 text-secondary mb-4">BENGALURU</h2>
            <img src="<?php echo $app->app_url; ?>assets/images/Sneha.jpg" alt="" class="img-fluid rounded mb-4" width="50%" height="auto">
            <h4 class="font-700 text-secondary">Dr. Sneha J</h4>
            <h6 class="mb-4">MBBS,MD (OBG) AIIMS,DNB (OBG), FIRM (Fellowship in Reproductive Medicine)</h6>
            <h6 class="mb-4">Sr. Consultant- Reproductive Medicine, Female Sexual
              Health & Gynaecologist</h6><br /><br />
            <div class="text-center"> <a class="btn btn-primary text-white font-700 " href="#form-section">BOOK AN APPOINTMENT</a></div>
          </div>
        </div>

        <div class="col-md-6  p-4">
          <div class="bg-white p-5">
            <h2 class="font-700 text-secondary mb-4">SHIVAMOGGA</h2>
            <img src="<?php echo $app->app_url; ?>assets/images/Abhilash.jpg" alt="" class="img-fluid rounded mb-4" width="50%" height="auto">
            <h4 class="font-700 text-secondary">Dr. Abhilash E</h4>
            <h6 class="mb-4">MBBS, MS, (Obstetrics & Gynaecology),
              Advanced Diploma in ART and Reproductive Medicine
              (UKSH- Kiel, Germany), Fellowship in Infertility and IVF
              (Gujrat University), Fellowship in Advanced Laparoscopy</h6>
            <h6 class="mb-4">Reproductive Medicine Specialist & Gynaec Laparoscopic Surgeon</h6>
            <div class="text-center"> <a class="btn btn-primary text-white font-700 " href="#form-section">BOOK AN APPOINTMENT</a></div>
          </div>
        </div>
      </div>

    </div>
  </section>
  <!-- team Ends -->

  <!-- Testimonials Starts -->
  <section class="section">
    <div class="container">
      <div class="row">
        <div class="col-md-12 text-center">
          <h2 class="font-700 text-primary mb-4">Patient Testimonials</h2>
        </div>
      </div>
      <div class="row">
        <div class="col-md-1"></div>
        <div class="col-md-10">
          <div class="owl-carousel owl-theme" id="testimonial-carousel">


            <div class="item">
              <div class="item p-5">
                <div class="col-md-12 p-4 bg-gray rounded ">
                  <h3 class="text-primary">Anjal</h3>
                  <h5>Dr.Sneha is very friendly & polite. Makes understand the pros and cons of the IVF. Listens to us and is transparent in every profession prosecure. Even responses on non duty hours for any consultant. Helps patient to be positive. </h5>
                  <img src="<?php echo $app->app_url; ?>/assets/images/quote.png" alt="" width="30%" class="mb-3 float-right">
                </div>
              </div>

            </div>
            <div class="item">
              <div class="item p-5">
                <div class="col-md-12 p-4 bg-gray rounded ">
                  <h3 class="text-primary">Sanjeetha</h3>
                  <h5>She is Super friendly! Anytime ready for her patient! M very lucky who got treatment with her for pregnancy! Success results at the very first time! Thank you so much doctor. </h5>
                  <img src="<?php echo $app->app_url; ?>/assets/images/quote.png" alt="" width="30%" class="mb-3 float-right">
                </div>
              </div>

            </div>
            <div class="item p-5">
              <div class="col-md-12 p-4 bg-gray rounded ">
                <h3 class="text-primary">Deepa</h3>
                <h5>Dr.Sneha is very friendly person with postivite attitude, <br>supportive and explains things in a simple way</h5>
                <img src="<?php echo $app->app_url; ?>/assets/images/quote.png" alt="" width="30%" class="mb-3 float-right">
              </div>
            </div>

          </div>
        </div>
        <div class="col-md-1"></div>
      </div>
    </div>
  </section>
  <!-- Testimonials Ends -->



  <!--  Starts -->
  <section class="section pt-0">
    <div class="container ">

      <div class="row align-items-center ">
        <div class="col-md-6  p-4">
          <div class="bg-primary text-white p-5">
            <img src="<?php echo $app->app_url; ?>/assets/images/Services-eng.png" alt="" width="100%" class="mb-3 ">
            <div class="text-center"> <a class="btn btn-white font-700 " href="#form-section">BOOK AN APPOINTMENT</a></div>
          </div>
        </div>

        <div class="col-md-6  p-4">
          <div class="bg-primary text-white p-5">
            <img src="<?php echo $app->app_url; ?>/assets/images/Services-kan.png" alt="" width="100%" class="mb-3 ">
            <div class="text-center"> <a class="btn btn-white font-700 " href="#form-section">BOOK AN APPOINTMENT</a></div>
          </div>
        </div>

      </div>

    </div>
  </section>
  <!--  Ends -->



  <!--  Starts -->
  <section class="section bg-secondary">
    <div class="container ">

      <div class="row align-items-center ">
        <div class="col-md-6 text-white p-4">
          <h5 class="mb-4 text-center font-600">NU Fertility @ <br> NU Hospitals Rajajinagar (West) <br> # 4/1, West of Chord Road, Near to ISKCON, Rajajinagar, Bengaluru, Karnataka, 560010. India</h5>
          <h5 class="mb-4 text-center"><a href="tel:9606971222" class="text-white font-700">Contact : 9606971222</a></h5>
          <div class="text-center"> <a class="btn btn-white font-700 " href="https://www.google.com/maps?client=firefox-b-d&sca_esv=5b7a4e7a7d376703&sca_upv=1&sxsrf=ADLYWIIUaPpWFD9Ar472OYJAUbtTn1wiig:1719311823995&uact=5&gs_lp=Egxnd3Mtd2l6LXNlcnAiigFOVSBGZXJ0aWxpdHkgQApOVSBIb3NwaXRhbHMgUmFqYWppbmFnYXIgKFdlc3QpCiMgNC8xLCBXZXN0IG9mIENob3JkIFJvYWQsIE5lYXIgdG8gSVNLQ09OLApSYWphamluYWdhciwgQmVuZ2FsdXJ1LCBLYXJuYXRha2EsIDU2MDAxMC4gSW5kaWFIAFAAWABwAHgAkAEAmAEAoAEAqgEAuAEDyAEA-AEC-AEBmAIAoAIAmAMAkgcAoAcA&um=1&ie=UTF-8&fb=1&gl=in&sa=X&geocode=KbGb5BaAPa47MW0YIXhAMkJr&daddr=4/1,+Chord+Rd,+near+to+ISKCON,+Rajajinagar,+Bengaluru,+Karnataka+560010" target="_blank">CLICK HERE FOR DIRECTIONS</a></div>
        </div>

        <div class="col-md-6 text-white p-4">
          <h5 class="mb-4 text-center font-600">NU Hospitals Super Speciality Clinic –
            Shivamogga (Nephrology-Urology &
            Fertility Out-Patient Clinic)
            No.6/2265, Kuvempu Road, Shivamogga-577201</h5>
          <h5 class="mb-4 text-center"><a href="tel:8792561350" class="text-white font-700">Contact : 8792561350</a></h5>
          <div class="text-center"> <a class="btn btn-white font-700 " href="https://www.google.com/maps/dir/13.0678784,77.5028736/NU+Hospitals+Super+Speciality+Clinic+%E2%80%93+Shivamogga+(Nephrology-Urology+%26+Fertility+Out-Patient+Clinic)+No.6%2F2265,+Kuvempu+Road,+Shivamogga-577201/@13.5978594,75.2496576,8z/data=!3m1!4b1!4m9!4m8!1m1!4e1!1m5!1m1!1s0x3bbba994c6c4df5f:0x1177289b32d90410!2m2!1d75.5682478!2d13.9377225?entry=ttu" target="_blank">CLICK HERE FOR DIRECTIONS</a></div>
        </div>

      </div>

    </div>
  </section>
  <!--  Ends -->



  <!-- Footer Starts -->
  <section class="section bg-white p-3">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-12">
          <h5 class="mb-0 text-dark font-700 text-center"> NU Fertility &copy; 2024. All Rights Reserved.</h5>
        </div>

      </div>
    </div>
  </section>
  <!-- Footer Ends -->




  <!-- Optional JavaScript -->
  <!-- jQuery first, then Popper.js, then Bootstrap JS -->
  <script src="<?php echo $app->app_url; ?>node_modules/jquery/dist/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
  <script src="<?php echo $app->app_url ?>node_modules/bootstrap/dist/js/bootstrap.min.js"></script>
  <script src="<?php echo $app->app_url; ?>assets/js/owl/owl.carousel.min.js"></script>
  <script src="<?php echo $app->app_url; ?>assets/js/app.js"></script>
  <script src="popup/script.js"></script>
</body>

</html>