<?php if (get_theme_mod('kotha_home_layout') == 'full') {

} else { ?>
    <div class="col-md-4">
        <div class="primary-sidebar widget-area" role="complementary">
            <?php dynamic_sidebar('blog-sidebar'); ?>

            <?php
            $current_post_id = get_the_ID();
            $post_categories = get_the_category($current_post_id);

            $related_posts_args = array(
                'category__in' => wp_list_pluck($post_categories, 'term_id'),
                'post__not_in' => array($current_post_id),
                'posts_per_page' => 3,
                'ignore_sticky_posts' => 1,
            );

            $related_posts_query = new WP_Query($related_posts_args);

            if ($related_posts_query->have_posts()) {
                echo '<aside class="widget">';
                echo '<h1 class="widget-title">Related Posts</h1>';
                echo '<ul>';
                while ($related_posts_query->have_posts()) {
                    $related_posts_query->the_post();
                    echo '<li><a href="' . get_permalink() . '">' . get_the_title() . '</a></li>';
                }
                echo '</ul>';
                echo '</aside>';

                wp_reset_postdata();
            }
            ?>
        </div>
    </div>
<?php }
?>