/* global jQuery:false */

jQuery(document).on('action.ready_trx_addons', function() {
	"use strict";

	// Add arrows to the WooCommerce categories on homepages
	jQuery('body:not(.woocommerce) .widget_area:not(.footer_wrap) .widget_product_categories ul.product-categories .has_children > a').append('<span class="open_child_menu"></span>');

	// Open/Close submenu
	jQuery('body:not(.woocommerce) .widget_area:not(.footer_wrap) .widget_product_categories').on('click', 'ul.product-categories.plain li a .open_child_menu', function(e) {
		"use strict";
		var $a = jQuery(this).parent();
		if ($a.siblings('ul:visible').length > 0)
			$a.siblings('ul').slideUp().parent().removeClass('opened');
		else {
			jQuery(this).parents('li').siblings('li').find('ul:visible').slideUp().parent().removeClass('opened');
			$a.siblings('ul').slideDown().parent().addClass('opened');
		}
		e.preventDefault();
		return false;
	});

	// Resize handlers
	jQuery(document).on('action.resize_trx_addons', function() {
		"use strict";
		trx_addons_woocommerce_resize_actions();
	});
	trx_addons_woocommerce_resize_actions();

	// Switch popup menu / hierarchical list on product categories list placed in sidebar
	function trx_addons_woocommerce_resize_actions() {
		var cat_menu = jQuery('body:not(.woocommerce) .widget_area:not(.footer_wrap) .widget_product_categories ul.product-categories');
		var sb = cat_menu.parents('.widget_area');
		if (sb.length > 0 && cat_menu.length > 0) {
			if (sb.width() == sb.parents('.content_wrap').width()) {
				if (cat_menu.hasClass('inited')) {
					cat_menu.removeClass('inited').addClass('plain').superfish('destroy');
					cat_menu.find('ul.animated').removeClass('animated').addClass('no_animated');
				}
			} else {
				if (!cat_menu.hasClass('inited')) {
					cat_menu.removeClass('plain').addClass('inited');
					cat_menu.find('ul.no_animated').removeClass('no_animated').addClass('animated');
					basekit_init_sfmenu('body:not(.woocommerce) .widget_area:not(.footer_wrap) .widget_product_categories ul.product-categories');
				}
			}
		}
	}
});