<?php
defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use Maatwebsite\Excel\Facades\Excel;
use App\Exports\FilteredContactsExport;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

class home extends CI_Controller
{


	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function _construct()
	{
		// $this->load does not exist until after you call this
		parent::_construct(); // Construct CI's core so that you can use it

		$this->load->library('session');
		$this->load->helper('form');
	}
	public function testestt()
	{
		// dd('efvgef');
		$this->load->model('Db_query');
		$data['contactus'] = $this->Db_query->checkTableList();
		// $data = [];
		// $data['campaign'] = $this->Db_query->getcontactusdata();
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('contactus_data', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function filter()
	{

		$this->load->helper('url');
		$this->load->model('Db_query');

		// Get the search data and date range from the request
		$searchdata = $this->input->get('searchdata');
		$fromDate = $this->input->get('from_date');
		$toDate = $this->input->get('to_date');

		// Query initialization
		$results = $this->Db_query->getFilteredResults($searchdata, $fromDate, $toDate);
		// dd($results);


		// Return JSON response
		$this->output
			->set_content_type('application/json')
			->set_output(json_encode(['results' => $results]));
	}

	public function downloadFile()
	{
		try {

			$this->load->helper('url');
			$this->load->model('Db_query');

			$searchdata = $this->input->get('search');
			$fromDate = $this->input->get('from_date');
			$toDate = $this->input->get('to_date');

			$results = $this->Db_query->getFilteredResults($searchdata, $fromDate, $toDate);

			$csvData = $this->generateCsvData($results);
			print_r($csvData);
			die;


			$headers = [
				'Content-Type' => 'text/csv',
			];

			return response()->make($csvData, 200, $headers)
				->header('Content-Disposition', 'attachment; filename="filtered_contacts.csv"');
		} catch (\Exception $e) {
			Log::error('Error while downloading CSV file: ' . $e->getMessage());
			return response()->json(['error' => 'An error occurred while processing your request. Please try again later.'], 500);
		}
	}

	private function generateCsvData($results)
	{
		try {
			$csv = fopen('php://temp', 'w');

			fputcsv($csv, ['Name', 'Email', 'Phone', 'Message', 'Title', 'Date', 'Utm', 'Utm Source', 'Utm Medium', 'Utm Link']);

			foreach ($results as $item) {
				fputcsv($csv, [
					isset($item['name']) ? $item['name'] : '',
					isset($item['email']) ? $item['email'] : '',
					isset($item['phone']) ? $item['phone'] : '',
					isset($item['message']) ? $item['message'] : '',
					isset($item['title']) ? $item['title'] : '',
					isset($item['date_added']) ? date('Y-m-d H:i:s', strtotime($item['date_added'])) : '',
					isset($item['utm']) ? $item['utm'] : '',
					isset($item['utm_source']) ? $item['utm_source'] : '',
					isset($item['utm_medium']) ? $item['utm_medium'] : '',
					isset($item['utm_link']) ? $item['utm_link'] : ''
				]);
			}
			rewind($csv);

			$csvData = stream_get_contents($csv);

			fclose($csv);

			return $csvData;
		} catch (\Exception $e) {

			Log::error('Error while generating CSV data: ' . $e->getMessage());

			throw new \Exception('Error while generating CSV data');
		}
	}

	public function tablelist()
	{
		$this->load->model('Db_query');
		$this->Db_query->tablelist();
	}
	public function index()
	{
		$data = [];
		$this->load->model('Db_query');
		$data['latestBlogs'] = $this->Db_query->getLatestBlogs();
		$this->load->view('templates/head-tags');

		$this->load->view('templates/header');

		$this->load->view('home', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function our_team()
	{
		$this->load->database();
		$this->load->model('Db_query');

		$data['doc'] = $this->Db_query->get_doctors();
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('our-team', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function advantage_nu()
	{

		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('advantage-nu');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function ovulation_induction()
	{

		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('templates/metatags');

		$this->load->view('ovulation', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function sitemap()
	{

		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');

		$this->load->view('sitemap', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}



	public function semen()
	{

		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');

		$this->load->view('semen', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function  ashwini()
	{

		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');

		$this->load->view('ashwini', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function  sneha()
	{

		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');

		$this->load->view('sneha', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function  krishnaPrasad()
	{

		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');

		$this->load->view('krishnaPrasad', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function  pramod()
	{

		$data = new stdClass();
		$data->title = 'Dr. Pramod Krishnappa | Best Andrologist in Bangalore | Male Infertility Doctor | NU Fertility';
		$data->desc = "Dr Pramod Krishnappa, is one of the best andrologist in Bangalore available at NU Hospitals and NU Fertility. Providing best treatment for Male Infertility and Male Sexual Dysfunction.";

		// remove session datas
		$this->load->view('templates/head-tags', $data);
		$this->load->view('templates/header');

		$this->load->view('pramod', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	// public function  abhilash()
	// {

	// 	$data = new stdClass();
	// 	$data->title = 'Dr. Abhilash E | NU Fertility';
	// 	$data->desc = "Dr. Abhilash E is a highly qualified Obstetrics and Gynaecology specialist with expertise in infertility and reproductive medicine.";

	// 	// remove session datas
	// 	$this->load->view('templates/head-tags', $data);
	// 	$this->load->view('templates/header');

	// 	$this->load->view('abhilash', $data);
	// 	$this->load->view('templates/footer');
	// 	$this->load->view('templates/foot-tags');
	// }

	public function  dr_sneha_j_infertility_specialist()
	{


		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');

		$this->load->view('dr-sneha-j-infertility-specialist', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function curl_submit()
	{

		$data = new stdClass();

		// remove session datas


		$this->load->view('curl-submit', $data);
	}

	public function blastocyst()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');

		$this->load->view('blastocyst-transfer', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function ivf_icsi()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');

		$this->load->view('ivf-icsi', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function egg_donation()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('egg-donation', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function infertility_evaluation_and_workup()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('infertility-evaluation-and-workup', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function book_video_consultation()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));

		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('book-video-consultation');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function book_an_appointment()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));

		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('book-an-appointment');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function female_infertility()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));
		$data->title = 'Female & Male Infertility Tests & Causes| NU Fertility';
		$data->desc = 'Most cases of infertility in women result from problems with producing eggs. If you think you might be infertile, see your doctor. There are tests that may tell if you have fertility problems.';
		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags', $data);
		$this->load->view('templates/header');
		$this->load->view('female-infertility');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function male_infertility()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));

		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('male-infertility');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function era()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));

		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('era');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function ivf()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));
		$data->title = "Best IVF Treatment Center in Bangalore | IVF Hospital in India | NU Fertility";
		$data->desc = "NU Fertility is one of the Best IVF Treatment Center in Bangalore has a team of IVF specialists expertise in diagnosing and treating infertility problems at affordable cost.";
		// $data->gtm = '<script async src="https://www.googletagmanager.com/gtag/js?id=AW-964416900"></script>';
		// $data->gtm .="<script> window.dataLayer = window.dataLayer || []; function gtag(){dataLayer.push(arguments);} gtag('js', new Date()); gtag('config', 'AW-964416900'); </script>";
		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags', $data);
		$this->load->view('templates/header');
		$this->load->view('ivf');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function blastocyst_embryo_transfer()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));

		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('blastocyst-embryo-transfer');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function service_frozen_embry()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));

		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('service-frozen-embry');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function iui()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));
		$data->title = 'IUI - Fertilization Enabling Treatment|NU Fertility';
		$data->desc = "Intrauterine insemination (IUI) is a fertility treatment that involves placing the washed sperms inside a woman's uterus to facilitate fertilization.";
		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags', $data);
		$this->load->view('templates/header');
		$this->load->view('iui');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function ovulation_induction_new()
	{
		$data = new stdClass();

		$this->load->helper(array('form', 'url'));

		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('ovulation-induction');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function book()
	{
		date_default_timezone_set("Asia/Kolkata");
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required');
		$this->form_validation->set_rules('email', 'Email', 'required');
		$this->form_validation->set_rules('phone', 'Phone', 'required');
		// remove session datas

		if ($this->form_validation->run() == false) {
			//$this->session->set_flashdata("email_sent","Validation Error");
			//book_appointment();
		} else {
			//to check if the validation run correctly
			//$this->load->view('welcome_message');
			$name = $this->input->post('name');
			$email = $this->input->post('email');
			$phone = $this->input->post('phone');
			$message = $this->input->post('message');
			$from_email = "noreply@nufirtility.com";
			// $to_email = $this->input->post('email');
			//$to_email = 'care@nuhospitals.com';
			$to_email = 'care@nuhospitals.com';
			//Load email library
			$this->load->library('email');
			$this->email->set_mailtype("html");
			$this->email->from($from_email, 'Book an Appointent');
			$this->email->to($to_email);
			$this->email->subject('Book an Appointent');
			$this->email->message(
				$name . '<br>' . $email . '<br>' . $phone . '<br>' . $message
			);
			//Send mail
			if ($this->email->send()) {
				//$this->session->set_flashdata("email_sent","Email sent successfully");
				$this->load->view('templates/head-tags');
				$this->load->view('templates/header');
				$this->load->view('thankyou');
				$this->load->view('templates/footer');
				$this->load->view('templates/foot-tags');
			} else {
				// $this->session->set_flashdata("email_sent","Error in sending Email");
				book_appointment();
			}
		}
	}
	public function faqs()
	{
		//$data = new stdClass();
		//$this->load->database();
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		// $this->load->model('Faqs_model');
		// $data['query'] = $this->Faqs_model->get_last_ten_entries();
		$this->load->view('faqs');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function news()
	{
		//$data = new stdClass();
		$this->load->database();
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		// $this->load->model('New_event');
		// $data['query'] = $this->New_event->get_last_ten_entries();
		$this->load->view('new-event');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function about_nu()
	{
		$data = new stdClass();
		if (!empty($_GET['debug'])) {

			$this->load->view('includes/header');
			$this->load->view('about-nu', $data);
			$this->load->view('includes/footer');
			return false;
		}
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('about-nu', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function andrology()
	{
		$data = new stdClass();
		$data->title = "Best Andrology Treatment Hospital In Bangalore | NU Fertility Hospitals";
		$data->desc = "Andrology is a subspecialty of Urology which involves treatment of various conditions causing male infertility and male sexual dysfunction. Get best Best Andrology Treatment in Bangalore at NU Fertility.";

		// remove session datas
		$this->load->view('templates/head-tags', $data);
		$this->load->view('templates/header');
		$this->load->view('andrology', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function men_sexual_health()
	{
		$data = new stdClass();
		$data->title = "Best Erectile Dysfunction Treatment in Bangalore | Best Impotence Treatment | Men's Sexual Health ";
		$data->desc = "Advanced Centre For Erectile Dysfunction  at NU Hospitals Bangalore. All you need to know about Erectile Dysfunction (Impotence). Erectile Dysfunction (ED) is a persistent inability to achieve or maintain an erection that is firm enough to have sexual intercourse. get treated Today, consult our Andrologist.";

		// remove session datas
		$this->load->view('templates/head-tags', $data);
		$this->load->view('templates/header');
		$this->load->view('men-sexual-health', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function male_fertility_problems()
	{
		$data = new stdClass();
		$data->title = "Male Infertility Treatment In Bangalore | Best Fertility Clinic  | NU Fertility";
		$data->desc = "NU Fertility is one of the the best male fertility treatment hospital in Bangalore with highly experienced andrologist providing male disorders & male infertility. Consult today and get treated.";

		// remove session datas
		$this->load->view('templates/head-tags', $data);
		$this->load->view('templates/header');
		$this->load->view('male-fertility-problems', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function packages()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('packages', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function premarital_package()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('premarital-package', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function mens_health_clinic()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('mens-health-clinic', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function gallery()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('gallery', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function facilities()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('facilities', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function kavya_v_pradeep()
	{
		$data = new stdClass();

		$data->title = "Dr. Kavya V Pradeep | Best Infertility doctors in Shimoga | Consultant Reproductive Medicine | Gynaecologist & Laparoscopic Surgeon Shomogga | Best fertility Hospitals in Shivamogga";
		$data->desc = "Dr. Kavya V Pradeep is an expert in the management of Best Infertility doctors, Reproductive Medicine, Gynaecology and Laparoscopic Surgery. She currently working in NU Hospitals and NU Fertility Shimogga.";
		$data->keyword = "Best Infertility Hospitals in Shivamogga, Best fertility Hospitals in Shivamogga, Dr. Kavya V Pradeep, Consultant Reproductive Medicine, Gynaecologist & Laparoscopic Surgeon Shomogga, Fertility Dotors in Shivamogga, Fertility hospital in Shivamogga, Infertility hospital in Shivamogga, Best IVF Center In Shivamogga, Infertility Treatment Centre Shivamogga, Fertility Centre Shivamogga, Best Fertility Clinics Shivamogga, IVF Centres in Shimoga, Best IVF Treatment in Shimoga, IVF Cost in Shivamogga, Infertility Treatment In Shimoga, fertility specialist in Shimoga, Infertility Treatment in Shimoga, fertility clinic Shimoga, Best Fertility Specialist Near Me, Fertility Doctors in Shimoga, Infertility Doctors in Shimoga, fertility clinic";
		// remove session datas
		$this->load->view('templates/head-tags', $data);
		$this->load->view('templates/header');
		$this->load->view('kavya-v-pradeep', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function prakrutha_sreenath()
	{
		$data = new stdClass();
		$data->title = "Dr Prakrutha | Reproductive Medicine Specialist in Padmanabhnagar, Bengaluru | NU Fertility";
		$data->desc = "Dr Prakrutha is a well-known obstetrician-gynaecologist and a noted fertility and IVF specialist. Consult her today for your all genecology issues.";

		// remove session datas
		$this->load->view('templates/head-tags',);
		$this->load->view('templates/header');
		$this->load->view('dr-prakrutha-sreenath', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	// public function dr_usha() {
	// 	$data = new stdClass();

	// 	// remove session datas
	// 	$this->load->view('templates/head-tags');
	// 	$this->load->view('templates/header');
	// 	$this->load->view('dr-usha',$data);
	// 	$this->load->view('templates/footer');
	// 		$this->load->view('templates/foot-tags');

	// }

	public function error()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('error', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}



	public function our_offering()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('our-offering', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function why_choose_us()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('why-choose-us', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function endometrial_receptivity_assay()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('endometrial-receptivity-assay', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function laparoscopic_surgery_and_hysteroscopic()
	{
		$data = new stdClass();
		$data->title = "Minimally Invasive Surgeries for Reproductive Organs In Bangalore| NU Fertility";
		$data->desc = "Nowadays, for many couples facing infertility problems, doctors are using Laparoscopy Treatment to help them overcome these adversities and help them have a family.";

		// remove session datas
		$this->load->view('templates/head-tags', $data);
		$this->load->view('templates/header');
		$this->load->view('laparoscopic-surgery-and-hysteroscopic', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function tese_pesa_micro_test()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('tese-pesa-micro-test', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function frozen_embryo_transfer()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('frozen-embryo-transfer', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function embryo_transfer()
	{
		$data = new stdClass();
		$data->title = 'Embryo Freezing and Frozen Embryo Transfer| NU Fertility';
		$data->desc = "A frozen embryo transfer (FET) is a cycle in which the frozen-thawed embryos can be transferred into the women's uterus. Get ovulation induction fertility treatment from the best fertility doctors in Bangalore.";
		// remove session datas
		$this->load->view('templates/head-tags', $data);
		$this->load->view('templates/header');
		$this->load->view('embryo-transfer', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function embryo_freezing()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('embryo-freezing', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function oocyte_freezing()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('oocyte-freezing', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function embryo_freezing_and_frozen_embryo_transfer()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('embryo-freezing-and-frozen-embryo-transfer', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function sperm_freezing()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('sperm-freezing', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function sperm_donation()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('sperm-donation', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function fertility_preservation()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('fertility-preservation', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function laparoscopic_surgery()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('laparoscopic-surgery', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function sperm_donation_new()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('sperm-donation-new', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function IVM()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('ivm', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function MicroTESE()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('microTESE', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	// public function international_patients() {
	// 	$data = new stdClass();

	// 		// remove session datas
	// 		$this->load->view('templates/head-tags');
	// 		$this->load->view('templates/header');
	// 		$this->load->view('international-patients',$data);
	// 		$this->load->view('templates/footer');
	// 		  $this->load->view('templates/foot-tags');

	// }
	public function international_patients()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));

		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('international-patients');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function egg_sperm_embryo_freezing()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('egg-sperm-embryo-freezing', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function male_infertility_evaluation_and_treatment()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');

		$this->load->view('templates/header');
		$this->load->view('male-infertility-evaluation-and-treatment', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function in_vitro_maturation()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('in-vitro-maturation', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function careers()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));

		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('careers');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function contact()
	{
		$data = new stdClass();

		$this->load->helper(array('form', 'url'));

		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('contact');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function career_book()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required');
		$this->form_validation->set_rules('email', 'Email', 'required');
		$this->form_validation->set_rules('phone', 'Phone', 'required');
		$this->form_validation->set_rules('gender', 'Gender', 'required');
		$this->form_validation->set_rules('qualification', 'Qualification', 'required');
		$this->form_validation->set_rules('experience', 'Experience', 'required');
		$this->form_validation->set_rules('city', 'City', 'required');
		$this->form_validation->set_rules('current_employer', 'current_employer', 'required');
		$this->form_validation->set_rules('gender', 'Gender', 'required');

		// remove session datas

		if ($this->form_validation->run() == false) {
			//$this->session->set_flashdata("email_sent","Validation Error");
			//book_appointment();
		} else {
			//to check if the validation run correctly
			//$this->load->view('welcome_message');
			$name = $this->input->post('name');
			$email = $this->input->post('email');
			$phone = $this->input->post('phone');
			$gender = $this->input->post('gender');
			$qualification = $this->input->post('qualification');
			$experience = $this->input->post('experience');
			$city = $this->input->post('city');
			$current_employer = $this->input->post('current_employer');
			$message = $this->input->post('message');
			$from_email = "noreply@nufirtility.com";
			// $to_email = $this->input->post('email');
			//$to_email = 'care@nuhospitals.com';
			$to_email = 'hr@nuhospitals.com';
			//Load email library
			$this->load->library('email');

			$this->email->from($from_email, 'Join Us');
			$this->email->to($to_email);
			$this->email->subject('Join Us');
			$this->email->message(
				$name . '<br>' . $email . '<br>' . $phone . '<br>' . $gender . '<br>' . $qualification . '<br>' . $experience . '<br>' . $city . '<br>' . $current_employer . '<br>' . $message
			);
			//Send mail
			if ($this->email->send()) {
				//$this->session->set_flashdata("email_sent","Email sent successfully");
				$this->load->view('templates/head-tags');
				$this->load->view('templates/header');
				$this->load->view('thankyou');
				$this->load->view('templates/footer');
				$this->load->view('templates/foot-tags');
			} else {
				// $this->session->set_flashdata("email_sent","Error in sending Email");
				careers();
			}
		}
	}

	public function expert()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));

		$this->load->library('form_validation');
		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('expert');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function thankyou()
	{
		$data = new stdClass();



		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('thankyou');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function enquiry_failed()
	{
		$data = new stdClass();



		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('enquiry-failed');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}



	public function expert_book()
	{
		$data = new stdClass();
		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required');
		$this->form_validation->set_rules('email', 'Email', 'required');
		$this->form_validation->set_rules('phone', 'Phone', 'required');
		$this->form_validation->set_rules('gender', 'Gender', 'required');


		// remove session datas

		if ($this->form_validation->run() == false) {
			//$this->session->set_flashdata("email_sent","Validation Error");
			//book_appointment();
		} else {
			//to check if the validation run correctly
			//$this->load->view('welcome_message');
			$name = $this->input->post('name');
			$email = $this->input->post('email');
			$phone = $this->input->post('phone');
			$gender = $this->input->post('gender');

			$message = $this->input->post('message');
			$from_email = "noreply@nufirtility.com";

			// $to_email = $this->input->post('email');
			//$to_email = 'care@nuhospitals.com';
			$to_email = 'care@nuhospitals.com';
			//Load email library
			$this->load->library('email');

			$this->email->from($from_email, 'Expert Opinion');
			$this->email->to($to_email);
			$this->email->subject('Expert Opinion');
			$this->email->message(
				$name . '<br>' . $email . '<br>' . $phone . '<br>' . $gender . '<br>' . $message
			);
			//Send mail
			if ($this->email->send()) {
				//$this->session->set_flashdata("email_sent","Email sent successfully");
				$this->load->view('templates/head-tags');
				$this->load->view('templates/header');
				$this->load->view('thankyou');
				$this->load->view('templates/footer');
				$this->load->view('templates/foot-tags');
			} else {
				// $this->session->set_flashdata("email_sent","Error in sending Email");
				careers();
			}
		}
	}

	public function landing_page_submit()
	{
		$ch = curl_init();
		$header = array();
		curl_setopt($ch, CURLOPT_URL, "https://endpoint.in.ext.con.nufertility.com/api/crm/landing-page");
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($_POST));

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$server_output = curl_exec($ch);
		print_r($server_output);
		if (curl_error($ch)) {
			curl_close($ch);
			header('Location: https://www.nufertility.com');
		} else {
			curl_close($ch);
			header('Location: https://www.nufertility.com/thank-you');
		}
	}
	// female sex health
	public function annual_gynaecologiccare()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('annual-gynaecologiccare');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function cosmetic_gynaecology()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('cosmetic-gynaecology');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function female_sex_health_overview()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('female-sex-health-overview');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function genitourinary_syndrome_ofmenopause()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('genitourinary-syndrome-ofmenopause');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function low_libido()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('low-libido');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function menopause_care()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('menopause-care');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function orgasm_concerns()
	{
		$data = new stdClass();

		$this->load->view('templates/head-tags', $data);
		$this->load->view('templates/header');
		$this->load->view('orgasm-concerns', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function pain_with_sex()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('pain-with-sex');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function pelvic_pain()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('pelvic-pain');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function sexual_health_concerns()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('sexual-health-concerns');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function vestibulectomy_surgery()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('vestibulectomy-surgery');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function vestibulodynia()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('vestibulodynia');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	// end female sex health

	public function health_check_up()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('health-packages');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function women_health_checkup()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('women-health-checkup');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function male_preconception_fertility_pack()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('male-preconception-fertility-pack');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function female_preconception_fertility_pack()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('female-preconception-pack');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function code_of_ethics_and_conduct()
	{
		$data = new stdClass();

		// remove session datas
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('code-of-ethics-and-conduct', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function send_to_api_proxy()
	{
		// Your code to proxy the request to the external API goes here
		dd("here");
	}

	public function send_to_api()
	{
		dd("here");
	}

	public function submit_func()
	{
		$post = $this->input->post();

		// Check Google reCAPTCHA
		if (!$this->checkGoogleKey($post['g-recaptcha-response'])) {
			redirect('https://www.nuhospitals.com/error');
			exit();
		}

		$headers = [
			'Content-Type: application/json',
			'Authorization: Basic N3RkbWZna2JtZDljOWF1M2MzNmFoZjk2MjZzb3plMGZnZTdmamQwNGFqdHUwcWkxdms=',
		];

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "https://nuhospitals.kapturecrm.com/add-ticket-from-other-source.html/v.2.0");
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_POST, 1);

		// Prepare JSON data
		$jsonData = [
			"title" => !empty($post['title']) ? $post['title'] : "",
			"ticket_details" => !empty($post['message']) ? $post['message'] : "",
			"due_date" => "",
			"customer_name" => isset($post['name']) ? $post['name'] : '',
			"phone" => isset($post['phone']) ? $post['phone'] : '',
			"email_id" => isset($post['email']) ? $post['email'] : '',
			// Add other fields as needed
		];

		// Handle 'utm' data based on 'page' and 'current_url' presence
		if (!empty($post['page'])) {
			$tableName = $this->db->get_where('Campaign', array('campaign_id' => $post['current_url']))->row();
			if (!empty($post['current_url'])) {
				$jsonData['utm'] = [
					'department' => isset($tableName->department) ? $tableName->department : '',
					'medium' => isset($post['current_medium']) ? $post['current_medium'] : '',
					'campaign_id' => isset($post['current_url']) ? $post['current_url'] : '',
					'utm' => isset($post['current_id']) ? $post['current_id'] : '',
					'location' => isset($tableName->location) ? $tableName->location : '',
					'campaign_name' => isset($tableName->campaign_name) ? $tableName->campaign_name : '',
					'source' => isset($post['current_source']) ? $post['current_source'] : '',
				];
			} else {
				$jsonData['utm'] = [
					'department' => '',
					'medium' => '',
					'utm' => '',
					'location' => '',
					'campaign_name' => '',
					'source' => '',
				];
			}
		}

		// Convert JSON data to a string
		$jsonString = json_encode($jsonData);

		// Set the JSON data as the request body
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Execute the cURL request
		$server_output = curl_exec($ch);

		if (curl_error($ch)) {
			curl_close($ch);
			redirect('https://www.nuhospitals.com');
		} else {
			// Handle successful response
			if ($this->session->has_userdata('emailAddress')) {
				if (isset($post['web_source']) && !empty($post['web_source'])) {
					if ($post['web_source'] == "contact-thankyou") {
						curl_close($ch);
						echo "<script>window.location.href = 'https://www.nuhospitals.com/contact-thankyou';</script>";
						exit();
					} else if ($post['web_source'] == "appointment-thankyou") {
						curl_close($ch);
						echo "<script>window.location.href = 'https://www.nuhospitals.com/appointment-thankyou';</script>";
						exit();
					} else {
						redirect('previous_page'); // Adjust the redirect URL
					}
				}
			}
			// Redirect to default page if session not set
			redirect('https://www.nuhospitals.com');
		}
	}

	public function contact_func(Request $request)
	{
		// dd("here");
		// dd($request->all());

		$header = array();
		$ch = curl_init();

		// Set the URL
		curl_setopt($ch, CURLOPT_URL, "https://nuhospitals.kapturecrm.com/add-ticket-from-other-source.html/v.2.0");

		// Set the HTTP headers
		$headers = [
			'Content-Type: application/json',
			'Authorization: Basic a2R6NmY3Z2t6ZW5qaHQ0cDJpcmhndjhqZGl3ZGRpaTVnYWd4a2t1Zzg3OThlMTJvdzg=',
		];

		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_POST, 1);

		// JSON data
		$jsonData = [
			[
				"title" => "Test",
				"ticket_details" => "Test Ticket",
				"due_date" => "",
				"customer_name" => $request->name,
				"phone" => $request->phone,
				"email_id" => $request->email,
				"make_an_appointment_(nu_hospitals)" => [
					[
						"your_mail" => "abhishek.prasad@kapturecrm.com",
						"your_message" => $request->message4,
						"phone" => $request->phone,
						"your_name" => $request->name,
						"subject" => $request->form_subject
					]
				]
			]
		];


		// Convert JSON data to a string
		$jsonString = json_encode($jsonData);

		// Set the JSON data as the request body
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Execute the cURL request
		$server_output = curl_exec($ch);
		//  print_r($server_output);  die;
		if (curl_error($ch)) {
			// Handle cURL error
			curl_close($ch);
			header('Location: https://www.nuhospitals.com');
		} else {
			// Handle successful response
			curl_close($ch);
			echo "<script>window.location.href = 'https://www.nuhospitals.com/requestthankyou';</script>";
			header('Location: https://www.nuhospitals.com/requestthankyou');
		}
	}
	function checkGoogleKey($key)
	{
		$secretKey = '6LfwChspAAAAALCfpKnqF7iWB7nW08xVJDVOhu6A';
		// post request to server

		$url =  'https://www.google.com/recaptcha/api/siteverify?secret=' . urlencode($secretKey) .  '&response=' . urlencode($key);
		$response = file_get_contents($url);
		$responseKeys = json_decode($response, true);
		header('Content-type: application/json');
		if ($responseKeys["success"]) {
			return true;
		} else {
			return false;
		}
	}

	public function ajaxsubmitContactForm()
	{
		foreach ($_POST as $name => $value) {
			$arr[$name] = $value;
		}
		if (!$this->checkGoogleKey($arr['g-recaptcha-response'])) {
			header('Location: /enquiry-failed');
			exit();
		}

		$responce = [];
		$responce['success'] = false;
		$responce['message'] = 'Something went wrong';

		$jsonData = [
			"title" =>  !empty($arr['title']) ? $arr['title'] : "",
			"ticket_details" => isset($arr['message']) ? $arr['message'] : '',
			"due_date" => "",
			"customer_name" => isset($arr['name']) ? $arr['name'] : '',
			"phone" => isset($arr['number']) ? $arr['number'] : '',
			"email_id" => isset($arr['email']) ? $arr['email'] : '',
		];


		// echo "<pre>"; print_r($jsonData); die();
		$header = array();
		$ch = curl_init();

		// Set the URL
		curl_setopt($ch, CURLOPT_URL, "https://nuhospitals.kapturecrm.com/add-ticket-from-other-source.html/v.2.0");

		// Set the HTTP headers
		$headers = [
			'Content-Type: application/json',
			'Authorization: Basic ZG53cDFrczF3dThvNTBqdDEzZ3EzNDRndXBhNnQ4eDhjbG5uMWNmYTI4ZGJiZW54OHA=',
		];

		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_POST, 1);

		// Convert JSON data to a string
		$jsonString = json_encode($jsonData);


		// Set the JSON data as the request body
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Execute the cURL request
		$server_output = curl_exec($ch);
		$server_output = json_decode($server_output, true);
		// echo "<pre>"; print_r($server_output);  die;
		if (curl_error($ch)) {

			curl_close($ch);
			if (!empty($server_output['status']) && $server_output['status'] == 'success') {
				$responce['success'] = true;
				$responce['message'] = 'we will be in touch soon to confirm your appointment time';
			}
		} else {
			curl_close($ch);
			if (!empty($server_output['status']) && $server_output['status'] == 'success') {
				$responce['success'] = true;
				$responce['message'] = 'we will be in touch soon to confirm your appointment time';
			}
		}
		echo  json_encode($responce);
	}
	public function insertContactRecord($data)
	{

		$this->load->model('Db_query');
		$mysqli = $this->Db_query->connectBlogDB();
		$columns = implode(', ', array_keys($data));
		$values = "'" . implode("', '", $data) . "'";
		$sql = "INSERT INTO contact_us ($columns) VALUES ($values)";

		// echo "<pre>"; print_r($sql); die();
		$result =  $mysqli->query($sql);
		//   if($result){
		//       echo "data inserted";
		//   }else{
		// 	echo "Error: " . $mysqli->error;
		//   }

	}

	public function submitContactForm()
	{

		$post = $this->input->post();

		// echo '<pre>'.print_r($post); die();

		$email = $post['email'];
		$phoneNumber = $post['number'];

		$this->session->set_userdata('emailAddress', $email);
		$this->session->set_userdata('phoneNumber', $phoneNumber);
		if (!$this->checkGoogleKey($post['g-recaptcha-response'])) {
			redirect('https://www.nuhospitals.com/error');
			exit();
		}

		$headers = [
			'Content-Type: application/json',
			'Authorization: Basic N3RkbWZna2JtZDljOWF1M2MzNmFoZjk2MjZzb3plMGZnZTdmamQwNGFqdHUwcWkxdms=',
		];

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "https://nuhospitals.kapturecrm.com/add-ticket-from-other-source.html/v.2.0");
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_POST, 1);

		// Prepare JSON data
		$jsonData = [
			"title" => !empty($post['title']) ? $post['title'] : "",
			"ticket_details" => !empty($post['message']) ? $post['message'] : "",
			"due_date" => "",
			"customer_name" => isset($post['name']) ? $post['name'] : '',
			"phone" => isset($post['number']) ? $post['number'] : '',
			"email_id" => isset($post['email']) ? $post['email'] : '',
			// Add other fields as needed
		];

		// Handle 'utm' data based on 'page' and 'current_url' presence
		if (!empty($post['page'])) {
			$this->load->model('Db_query');
			$mysqli = $this->Db_query->connectBlogDB();
			$id = $post['current_url'];
			$sql = "SELECT * FROM campaign WHERE campaign_id='$id'";
			$result = $mysqli->query($sql);
			if ($result->num_rows > 0) {

				$row = $result->fetch_assoc();
				// $data['campaign'] = $row;
				// echo '<pre>'.print_r($row); die();
			}
			// $query = $this->db->get_where('Campaign', array('campaign_id' => $post['current_url']));



			// echo '<pre>'.print_r($tableName);die();
			if (!empty($post['current_url'])) {
				$jsonData['utm'] = [
					'department' => isset($row['department']) ? $row['department'] : '',
					'medium' => isset($post['current_medium']) ? $post['current_medium'] : '',
					'campaign_id' => isset($post['current_url']) ? $post['current_url'] : '',
					'utm' => isset($post['current_id']) ? $post['current_id'] : '',
					'location' => isset($row['location']) ? $row['location'] : '',
					'campaign_name' => isset($row['campaign_name']) ? $row['campaign_name'] : '',
					'source' => isset($post['current_source']) ? $post['current_source'] : '',
				];
			} else {
				$jsonData['utm'] = [
					'department' => '',
					'medium' => '',
					'utm' => '',
					'location' => '',
					'campaign_name' => '',
					'source' => '',
				];
			}
		}

		$data['name'] = isset($post['name']) ? $post['name'] : '';
		$data['phone'] = isset($post['number']) ? $post['number'] : '';
		$data['message'] = isset($post['message']) ? $post['message'] : '';
		$data['email'] = isset($post['email']) ? $post['email'] : '';
		$data['title'] = isset($post['title']) ? $post['title'] : '';
		//$data['source']= 
		//$data['utm_source']=
		//$data['utm_medium']=
		//$data['utm_web']=

		// Convert JSON data to a string
		$jsonString = json_encode($jsonData);

		$this->insertContactRecord($data);


		// Set the JSON data as the request body
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Execute the cURL request
		$server_output = curl_exec($ch);



		if (curl_error($ch)) {
			curl_close($ch);
			redirect('https://www.nuhospitals.com');
		} else {
			// Handle successful response
			if ($this->session->has_userdata('emailAddress')) {
				if (isset($post['web_source']) && !empty($post['web_source'])) {
					if ($post['web_source'] == "contact-thankyou") {
						curl_close($ch);
						redirect('https://www.nufertility.com/thank-you');
						// echo "<script>window.location.href = 'https://www.nuhospitals.com/contact-thankyou';</script>";
						exit();
					} else if ($post['web_source'] == "appointment-thankyou" || $post['web_source'] == "international-patients-thankyou") {
						redirect('https://www.nufertility.com/thank-you');
						curl_close($ch);
						// echo "<script>window.location.href = 'https://www.nuhospitals.com/appointment-thankyou';</script>";
						exit();
					} else {
						redirect('previous_page'); // Adjust the redirect URL
					}
				}
			}
			// Redirect to default page if session not set
			redirect('https://www.nuhospitals.com');
		}
	}
	public function show_table_structure()
	{

		$this->load->database();

		if ($this->db->initialize()) {
			echo 'Database connection established successfully.';
		} else {
			echo 'Unable to establish a database connection.';
		}
	}


	public function campaignAdd()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('campaign-add');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function campaignInsert()
	{
		foreach ($_POST as $name => $value) {
			$arr[$name] = $value;
		}
		$this->load->model('Db_query');
		$mysqli = $this->Db_query->connectBlogDB();
		$data = array(
			'campaign_id' => isset($arr['campaign_id']) ? $arr['campaign_id'] : '',
			'campaign_name' => isset($arr['campaign_name']) ? $arr['campaign_name'] : "",
			'location' => isset($arr['location']) ? $arr['location'] : '',
			'department' => isset($arr['department']) ? $arr['department'] : '',
		);
		$columns = implode(', ', array_keys($data));
		$values = "'" . implode("', '", $data) . "'";
		$sql = "INSERT INTO campaign ($columns) VALUES ($values)";

		$result = $mysqli->query($sql);
		if ($result) {
			header('Location: /campaign-index');
		} else {
			echo " failed";
		}
	}
	public function campaignIndex()
	{
		$data = [];
		$this->load->model('Db_query');
		$data['campaign'] = $this->Db_query->getcampaign();
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('campaign-list', $data);
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function campaignEdit()
	{
		$id = $_GET['id'];
		$this->load->model('Db_query');
		$mysqli = $this->Db_query->connectBlogDB();
		$sql = "SELECT * FROM campaign WHERE id='$id'";
		$result = $mysqli->query($sql);
		if ($result->num_rows > 0) {

			$row = $result->fetch_assoc();
			$data['campaign'] = $row;

			$this->load->view('templates/head-tags');
			$this->load->view('templates/header');
			$this->load->view('campaign-edit', $data);
			$this->load->view('templates/footer');
			$this->load->view('templates/foot-tags');
		} else {
			$this->load->view('templates/head-tags');
			$this->load->view('templates/header');
			$this->load->view('campaign-edit', $data);
			$this->load->view('templates/footer');
			$this->load->view('templates/foot-tags');
		}
	}

	public function campaignUpdate()
	{
		$id = $_POST['id'];
		$this->load->model('Db_query');
		$mysqli = $this->Db_query->connectBlogDB();
		$campaign_id = isset($_POST['campaign_id']) ? $_POST['campaign_id'] : '';
		$campaign_name = isset($_POST['campaign_name']) ? $_POST['campaign_name'] : '';
		$location = isset($_POST['location']) ? $_POST['location'] : '';
		$department = isset($_POST['department']) ? $_POST['department'] : '';

		$sql = "UPDATE campaign
		SET campaign_id='$campaign_id',campaign_name ='$campaign_name', location ='$location' , department='$department' WHERE id = '$id'";
		$result = $mysqli->query($sql);
		if ($result) {
			header('Location: /campaign-index');
		} else {
			echo " failed" . " " . $mysqli->error;
		}
	}

	public function campaignDelete()
	{
		$id = $_GET['id'];
		$this->load->model('Db_query');
		$this->load->helper('url');
		$mysqli = $this->Db_query->connectBlogDB();
		$sql = "DELETE FROM campaign where id=$id";
		$result = $mysqli->query($sql);
		if ($result) {
			header('Location: /campaign-index');
		} else {
			echo " failed" . " " . $mysqli->error;
		}
	}

	public function dubplicate_appointment()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('book-an-appointment-2');
		// $this->load->view('templates/foot-tags');
	}

	public function shivamogga_fertility_preservation()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('shivamogga-fertility-preservation');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function shivamogga_ivf()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('shivamogga-ivf');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}
	public function shivamogga_iui()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('shivamogga-iui');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function shivamogga_era_test()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('shivamogga-ert-test');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function shivamogga_ovulation_induction()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('shivamogga-ovulation-induction');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function shivamogga_female_infertility()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('shivamogga-female-infertility');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function shivamogga_robotic_laparoscopic()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('shivamogga-robotic-laparoscopic');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function shivamogga_ivm()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('shivamogga-ivm');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function shivamogga_hysteroscopic_fertility()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('shivamogga-hysteroscopic-fertility');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function shivamogga_laparoscopic_surgery()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('shivamogga-laparoscopic-surgery-and-hysteroscopic');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	public function shivamogga_painless_procedure_for_vaginal()
	{
		$this->load->view('templates/head-tags');
		$this->load->view('templates/header');
		$this->load->view('shivamogga-painless-cosmetic-procedure.php');
		$this->load->view('templates/footer');
		$this->load->view('templates/foot-tags');
	}

	// Define the responses function
	public function responses()
	{
		// Get JSON data from the request body
		$json = file_get_contents('php://input');
		// Decode JSON data into an object
		$post = json_decode($json, true);
		// echo "<pre>";		
		// print_r($post);
		// die;

		$second_DB = $this->load->database('second', TRUE);

		$ch = curl_init();
		$responce = [];
		$responce['success'] = false;
		$responce['message'] = 'Something went wrong';

		curl_setopt($ch, CURLOPT_URL, "https://nuhospitals.kapturecrm.com/add-ticket-from-other-source.html/v.2.0");


		$headers = [
			'Content-Type: application/json',
			'Authorization: Basic N3RkbWZna2JtZDljOWF1M2MzNmFoZjk2MjZzb3plMGZnZTdmamQwNGFqdHUwcWkxdms=',
		];

		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_POST, 1);

		$name = $post['user-name'];
		$phone = $post['user-number'];
		$email = $post['user-email'];
		$message = $post['user-message'];
		$title = 'Urology Nuhospitals Home Page';

		$utm_campaign = $post['utm_campaign'];
		$utm_source = $post['utm_source'];
		$utm_medium = $post['utm_medium'];
		$utm_link = $post['utm_link'];

		$data['name'] = isset($name) ? $name : '';
		$data['source'] = isset($utm_source) ? $utm_source : '';
		$data['title'] = isset($title) ? $title : '';
		$data['email'] = isset($email) ? $email : '';
		$data['phone'] = isset($phone) ? $phone : '';
		$data['message'] = isset($message) ? $message : '';
		$data['utm'] = isset($utm_campaign) ? $utm_campaign : '';
		$data['utm_source'] = isset($utm_source) ? $utm_source : '';
		$data['utm_medium'] = isset($utm_medium) ? $utm_medium : '';
		$data['utm_link'] = isset($utm_link) ? $utm_link : '';
		$data['created_at'] = date("Y-m-d H:i:s");

		$second_DB->insert('contact_us', $data);

		$tableName = $second_DB->get_where('campaign', array('campaign_id' => $utm_campaign))->row();

		if (!empty($utm_campaign)) {
			$jsonData = [
				"title" => !empty($title) ? $title : "",
				"ticket_details" => !empty($message) ? $message : "",
				"due_date" => "",
				"customer_name" =>  isset($name) ? $name : '',
				"phone" => isset($phone) ? $phone : '',
				"email_id" => isset($email) ? $email : '',
				'utm' => [
					'department' => isset($tableName->department) ? $tableName->department : '',
					'medium' => isset($utm_medium) ? $utm_medium : '',
					'campaign_id' => isset($utm_campaign) ? $utm_campaign : '',
					'utm' => isset($utm_campaign) ? $utm_campaign : '',
					'location' => isset($tableName->location) ? $tableName->location : '',
					'campaign_name' => isset($tableName->campaign_name) ? $tableName->campaign_name : '',
					'source' => isset($utm_source) ? $utm_source : '',
				]
			];
		} else {
			$jsonData = [
				"title" => !empty($title) ? $title : "",
				"ticket_details" => !empty($message) ? $message : "",
				"due_date" => "",
				"customer_name" =>  isset($name) ? $name : '',
				"phone" => isset($phone) ? $phone : '',
				"email_id" => isset($email) ? $email : '',
				'utm' => [
					'department' => '',
					'medium' => '',
					'utm' => '',
					'location' => '',
					'campaign_name' => '',
					'source' => '',
				]
			];
		}





		$jsonString = json_encode($jsonData);

		// Set the JSON data as the request body
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Execute the cURL request
		$server_output = curl_exec($ch);

		$server_output = json_decode($server_output, true);

		if (curl_error($ch)) {
			$responce['success'] = false;
			$responce['message'] = 'Curl error';
		} else {
			curl_close($ch);
			$responce['success'] = true;
			$responce['message'] = 'Request sent successfully';
			$responce['data'] = $server_output;
		}

		echo json_encode($responce);
		// echo json_encode(array(
		// 	'selected' => $client,
		// 	'invoices' => $invoices
		// ));

		// return response()->json($responce);

	}
}
