<?php
session_start();
require_once __DIR__ . "/../vendor/autoload.php";
$app = require_once __DIR__ . '/../config/config.php';


//Set Default Time Zone
date_default_timezone_set($app->timezone);

//Set App Environment
switch ($app->app_environment) {
	case 'production':
		error_reporting(E_ALL);
		ini_set('display_errors', 'Off');
		ini_set('display_startup_errors', 'Off');
		header_remove('X-Powered-By');
		break;

	case 'development':
		error_reporting(E_ALL);
		ini_set('display_errors', 'On');
		ini_set('display_startup_errors', 'On');
		ini_set('log_errors', 'On');
		ini_set("error_log", "errors.log");
		header_remove('X-Powered-By');
		break;

	default:
		error_reporting(E_ALL);
		ini_set('display_errors', 'On');
		ini_set('display_startup_errors', 'On');
		// ini_set('log_errors', 'On');
		// ini_set("error_log", "errors.log");
		break;
}
