$(document).ready(function () {


    $('#landing-submit').click(function (e) {
        e.preventDefault();
        var valid_full_name = false;
        var valid_email = false;
        var valid_phone = false;

        var input_full_name = $('#full_name').val();
        var input_email = $('#email').val();
        var input_phone = $('#phone').val();
        var input_city = $('#select_city').val();
        var input_dr = $('#doctors').val();

        valid_full_name = validate_full_name(input_full_name);
        valid_email = validate_email(input_email);
        valid_phone = validate_phone(input_phone);

        if (valid_full_name == false) {
            $('#full_name').addClass('form-control form-border-red');
        } else {
            $('#full_name').removeClass('form-border-red');
        }

        if (valid_email == false) {
            $('#email').addClass('form-control form-border-red');
        } else {
            $('#email').removeClass('form-border-red');
        }

        if (valid_phone == false) {
            $('#phone').addClass('form-control form-border-red');
        } else {
            $('#phone').removeClass('form-border-red');
        }
        if (valid_full_name == true && valid_email == true && valid_phone == true) {

            const data = {
                name: input_full_name,
                email: input_email,
                source: 'IVF',
                location:input_city,
                doctor:input_dr,
                contact:input_phone
            }
            // if(error_length == 0){
                $.ajax({
                    type: 'POST',
                    // url: "https://endpoint.in.ext.con.nufertility.com/api/crm/landing-page",
                    url: "http://localhost:8000/api/crm/landing-page",
                    data: data,
                    success: function (data) {
                        window.location.href='/IVF/thankyou.php';
                        console.log(data)
                    },
                    error: function (err) {
                        console.log(err);
                    }

                })
            // }
            // $('#landing-form').submit();
        } else {
            alert("Please fil all required fields");
        }



    });


});


// form validation methods Starts
function validate_full_name(input_full_name) {

    var full_name = input_full_name;
    var fullname_reg = /^[a-zA-Z\s]*$/;

    if (full_name.length < 3) {
        return false;
    }

    if (!fullname_reg.test(full_name)) {
        return false;
    }

    return true;

}

function validate_first_name(input_full_name) {

    var first_name = input_full_name;
    var first_reg = /^[a-zA-Z\s]*$/;

    if (first_name.length < 3) {
        return false;
    }

    if (!first_reg.test(first_name)) {
        return false;
    }

    return true;

}

function validate_last_name(input_full_name) {

    var last_name = input_full_name;
    var last_reg = /^[a-zA-Z\s]*$/;

    if (last_name.length < 3) {
        return false;
    }

    if (!last_reg.test(last_name)) {
        return false;
    }

    return true;

}

function validate_email(input_email) {
    var email = input_email;
    var emailReg = /^[a-zA-Z0-9.!#$%&ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;

    if (!emailReg.test(email)) {
        return false;
    }

    return true;
}

function validate_phone(input_phone) {
    var phone = input_phone;
    var phoneReg = /^\(?(\d{3})\)?[- ]?(\d{3})[- ]?(\d{4})$/;

    if (phone.length < 10) {
        return false;
    }

    if (!phoneReg.test(phone)) {
        return false;
    }

    return true;

}
// form validation methods Ends

$(document).ready(function () {

    $('#snorebtn a').on('click', function () {
        var sel = $(this).data('title');
        var tog = $(this).data('toggle');
        $('#' + tog).prop('value', sel);

        $('a[data-toggle="' + tog + '"]').not('[data-title="' + sel + '"]').removeClass('active').addClass('notActive');
        $('a[data-toggle="' + tog + '"][data-title="' + sel + '"]').removeClass('notActive').addClass('active');
    })

    $('#tiredbtn a').on('click', function () {
        var sel = $(this).data('title');
        var tog = $(this).data('toggle');
        $('#' + tog).prop('value', sel);

        $('a[data-toggle="' + tog + '"]').not('[data-title="' + sel + '"]').removeClass('active').addClass('notActive');
        $('a[data-toggle="' + tog + '"][data-title="' + sel + '"]').removeClass('notActive').addClass('active');
    })

    $('.btn-warning').click(function () {
        $('.form-wrapper').removeClass('bg-white');
        $('.form-wrapper').addClass('bg-primary');
        $('.form-wrapper').addClass('shadow-lg');

        setTimeout(function () {
            $('.form-wrapper').removeClass('bg-primary');
            $('.form-wrapper').addClass('bg-white');
            $('.form-wrapper').removeClass('shadow-lg');
        }, 1000)
    });

    var doctor_list = {
        "Rajajinagar" : ["Dr Ashwini","Dr Sneha"],
        "Padmanabhanagar" : ["Dr Prakrutha Sreenath"],
        "Shivamogga" : ["Dr Kavya V Pradeep "],
        }


        jQuery('#select_city').change(function(){
            var city =$(this).val();
            jQuery('#doctors').empty();
            if(city != ""){
                jQuery('#doctors').append('<option value="">Select Doctor<li>');
              var lists= doctor_list[city]
              $.each(lists, function(index, value) {
                jQuery('#doctors').append('<option value="'+value+'">'+value+'<li>');
              });
            }else{
                jQuery('#doctors').append('<option value="">Select Doctor<li>');

            }
        });


    $(window).scroll(function () {
        if ($(document).scrollTop() > 200) {
            $(".form-wrapper").addClass("form-fixed");
        } else {
            $(".form-wrapper").removeClass("form-fixed");
        }
    });



});
